/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.printers;

import com.tencent.tendon.convert.json.JsonPrinter;
import com.tencent.tendon.convert.json.JsonWriter;
import com.tencent.tendon.convert.json.JsonXListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonLongArrayPrinter
extends JsonPrinter<long[]> {
    public static final JsonLongArrayPrinter instance = new JsonLongArrayPrinter();
    private static final JsonXListener listener = JsonXListener.getInstance();

    private JsonLongArrayPrinter() {
    }

    @Override
    public final void convertTo(JsonWriter jsonWriter, long[] lArray) {
        long[] lArray2 = lArray;
        if (lArray2 == null) {
            jsonWriter.writeNull();
            return;
        }
        if (lArray2.length == 0) {
            jsonWriter.write('[', ']');
            return;
        }
        jsonWriter.write('[');
        boolean bl = true;
        for (long l : lArray2) {
            if (!bl) {
                jsonWriter.write(',');
            }
            listener.convertLongTo(jsonWriter, l);
            if (!bl) continue;
            bl = false;
        }
        jsonWriter.write(']');
    }

    @Override
    public Class<long[]> getType() {
        return long[].class;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

