/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonBoolArrayToken
extends JsonToken<boolean[]> {
    public static final JsonBoolArrayToken instance = new JsonBoolArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public boolean[] convertFrom(JsonReader jsonReader) {
        JsonBoolArrayList jsonBoolArrayList = JsonBoolArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonBoolArrayList.add(listener.convertBooleanFrom(jsonReader));
        }
        boolean[] blArray = jsonBoolArrayList.toArray();
        JsonBoolArrayList.offer(jsonBoolArrayList);
        return blArray;
    }

    @Override
    public Class<boolean[]> getType() {
        return boolean[].class;
    }

    public Class getComponentType() {
        return Boolean.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonBoolArrayList
    implements JsonPoolable {
        private static final Queue<JsonBoolArrayList> queue = new ArrayBlockingQueue<JsonBoolArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private boolean[] data;
        private int size;

        public static JsonBoolArrayList poll() {
            JsonBoolArrayList jsonBoolArrayList = queue.poll();
            if (jsonBoolArrayList == null) {
                jsonBoolArrayList = new JsonBoolArrayList();
            } else {
                jsonBoolArrayList.prepare();
            }
            return jsonBoolArrayList;
        }

        public static void offer(JsonBoolArrayList jsonBoolArrayList) {
            if (jsonBoolArrayList != null) {
                jsonBoolArrayList.release();
                queue.offer(jsonBoolArrayList);
            }
        }

        public JsonBoolArrayList() {
            this(8);
        }

        public JsonBoolArrayList(int n) {
            this.data = new boolean[n];
        }

        private void grow() {
            boolean[] blArray = new boolean[this.data.length + 8];
            System.arraycopy(this.data, 0, blArray, 0, this.size);
            this.data = blArray;
        }

        public void add(boolean bl) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = bl;
        }

        public boolean[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            boolean[] blArray = new boolean[this.size];
            System.arraycopy(this.data, 0, blArray, 0, this.size);
            return blArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new boolean[8];
        }

        public void clear() {
            this.release();
        }
    }
}

