/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonByteArrayToken
extends JsonToken<byte[]> {
    public static final JsonByteArrayToken instance = new JsonByteArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public byte[] convertFrom(JsonReader jsonReader) {
        JsonByteArrayList jsonByteArrayList = JsonByteArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonByteArrayList.add(listener.convertByteFrom(jsonReader));
        }
        byte[] byArray = jsonByteArrayList.toArray();
        JsonByteArrayList.offer(jsonByteArrayList);
        return byArray;
    }

    @Override
    public Class<byte[]> getType() {
        return byte[].class;
    }

    public Class getComponentType() {
        return Byte.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonByteArrayList
    implements JsonPoolable {
        private static final Queue<JsonByteArrayList> queue = new ArrayBlockingQueue<JsonByteArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private byte[] data;
        private int size;

        public static JsonByteArrayList poll() {
            JsonByteArrayList jsonByteArrayList = queue.poll();
            if (jsonByteArrayList == null) {
                jsonByteArrayList = new JsonByteArrayList();
            } else {
                jsonByteArrayList.prepare();
            }
            return jsonByteArrayList;
        }

        public static void offer(JsonByteArrayList jsonByteArrayList) {
            if (jsonByteArrayList != null) {
                jsonByteArrayList.release();
                queue.offer(jsonByteArrayList);
            }
        }

        public JsonByteArrayList() {
            this(8);
        }

        public JsonByteArrayList(int n) {
            this.data = new byte[n];
        }

        private void grow() {
            byte[] byArray = new byte[this.data.length + 8];
            System.arraycopy(this.data, 0, byArray, 0, this.size);
            this.data = byArray;
        }

        public void add(byte by) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = by;
        }

        public byte[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            byte[] byArray = new byte[this.size];
            System.arraycopy(this.data, 0, byArray, 0, this.size);
            return byArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new byte[8];
        }

        public void clear() {
            this.release();
        }
    }
}

