/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tendon.convert.json.tokens;

import com.tencent.tendon.convert.json.JsonPoolable;
import com.tencent.tendon.convert.json.JsonReader;
import com.tencent.tendon.convert.json.JsonToken;
import com.tencent.tendon.convert.json.JsonXListener;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonDoubleArrayToken
extends JsonToken<double[]> {
    public static final JsonDoubleArrayToken instance = new JsonDoubleArrayToken();
    private static final JsonXListener listener = JsonXListener.getInstance();

    @Override
    public double[] convertFrom(JsonReader jsonReader) {
        JsonDoubleArrayList jsonDoubleArrayList = JsonDoubleArrayList.poll();
        jsonReader.checkArray();
        while (jsonReader.hasNext()) {
            jsonDoubleArrayList.add(listener.convertDoubleFrom(jsonReader));
        }
        double[] dArray = jsonDoubleArrayList.toArray();
        JsonDoubleArrayList.offer(jsonDoubleArrayList);
        return dArray;
    }

    @Override
    public Class<double[]> getType() {
        return double[].class;
    }

    public Class getComponentType() {
        return Double.TYPE;
    }

    @Override
    public boolean isSimpled() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class JsonDoubleArrayList
    implements JsonPoolable {
        private static final Queue<JsonDoubleArrayList> queue = new ArrayBlockingQueue<JsonDoubleArrayList>(Math.max(Runtime.getRuntime().availableProcessors(), 2) * 2);
        private double[] data;
        private int size;

        public static JsonDoubleArrayList poll() {
            JsonDoubleArrayList jsonDoubleArrayList = queue.poll();
            if (jsonDoubleArrayList == null) {
                jsonDoubleArrayList = new JsonDoubleArrayList();
            } else {
                jsonDoubleArrayList.prepare();
            }
            return jsonDoubleArrayList;
        }

        public static void offer(JsonDoubleArrayList jsonDoubleArrayList) {
            if (jsonDoubleArrayList != null) {
                jsonDoubleArrayList.release();
                queue.offer(jsonDoubleArrayList);
            }
        }

        public JsonDoubleArrayList() {
            this(8);
        }

        public JsonDoubleArrayList(int n) {
            this.data = new double[n];
        }

        private void grow() {
            double[] dArray = new double[this.data.length + 8];
            System.arraycopy(this.data, 0, dArray, 0, this.size);
            this.data = dArray;
        }

        public void add(double d) {
            if (this.size == this.data.length) {
                this.grow();
            }
            this.data[this.size++] = d;
        }

        public double[] toArray() {
            if (this.size == this.data.length) {
                return this.data;
            }
            double[] dArray = new double[this.size];
            System.arraycopy(this.data, 0, dArray, 0, this.size);
            return dArray;
        }

        public void prepare() {
        }

        public void release() {
            this.size = 0;
            this.data = new double[8];
        }

        public void clear() {
            this.release();
        }
    }
}

