/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class RtfStylesheetList
extends RtfElement
implements RtfExtendedElement {
    private HashMap styleMap = new HashMap();
    private boolean defaultsLoaded = false;

    public RtfStylesheetList(RtfDocument doc) {
        super(doc);
    }

    public void writeContent(OutputStream out) throws IOException {
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        RtfParagraphStyle tempStyle = new RtfParagraphStyle(this.document, rtfParagraphStyle);
        tempStyle.handleInheritance();
        tempStyle.setStyleNumber(this.styleMap.size());
        this.styleMap.put(tempStyle.getStyleName(), tempStyle);
    }

    private void registerDefaultStyles() {
        this.defaultsLoaded = true;
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_NORMAL.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_NORMAL);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_1.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_1);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_2.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_2);
        }
        if (!this.styleMap.containsKey(RtfParagraphStyle.STYLE_HEADING_3.getStyleName())) {
            this.registerParagraphStyle(RtfParagraphStyle.STYLE_HEADING_3);
        }
    }

    public RtfParagraphStyle getRtfParagraphStyle(String styleName) {
        if (!this.defaultsLoaded) {
            this.registerDefaultStyles();
        }
        if (this.styleMap.containsKey(styleName)) {
            return (RtfParagraphStyle)this.styleMap.get(styleName);
        }
        return null;
    }

    public void writeDefinition(OutputStream result) throws IOException {
        result.write(DocWriter.getISOBytes("{"));
        result.write(DocWriter.getISOBytes("\\stylesheet"));
        result.write(RtfBasicElement.DELIMITER);
        this.document.outputDebugLinebreak(result);
        for (RtfParagraphStyle rps : this.styleMap.values()) {
            rps.writeDefinition(result);
        }
        result.write(DocWriter.getISOBytes("}"));
        this.document.outputDebugLinebreak(result);
    }
}

