/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable
extends RtfElement {
    private ArrayList rows = null;
    private float tableWidthPercent = 80.0f;
    private float[] proportionalWidths = null;
    private float cellPadding = 0.0f;
    private float cellSpacing = 0.0f;
    private RtfBorderGroup borders = null;
    private int alignment = 1;
    private boolean cellsFitToPage = false;
    private boolean tableFitToPage = false;
    private int headerRows = 0;
    private int offset = -1;

    public RtfTable(RtfDocument doc, Table table) {
        super(doc);
        table.complete();
        this.importTable(table);
    }

    public RtfTable(RtfDocument doc, PdfPTable table) {
        super(doc);
        this.importTable(table);
    }

    private void importTable(Table table) {
        this.rows = new ArrayList();
        this.tableWidthPercent = table.getWidth();
        this.proportionalWidths = table.getProportionalWidths();
        this.cellPadding = (float)((double)table.getPadding() * 20.0);
        this.cellSpacing = (float)((double)table.getSpacing() * 20.0);
        this.borders = new RtfBorderGroup(this.document, 1, table.getBorder(), table.getBorderWidth(), table.getBorderColor());
        this.alignment = table.getAlignment();
        int i = 0;
        Iterator rowIterator = table.iterator();
        while (rowIterator.hasNext()) {
            this.rows.add(new RtfRow(this.document, this, (Row)rowIterator.next(), i));
            ++i;
        }
        for (i = 0; i < this.rows.size(); ++i) {
            ((RtfRow)this.rows.get(i)).handleCellSpanning();
            ((RtfRow)this.rows.get(i)).cleanRow();
        }
        this.headerRows = table.getLastHeaderRow();
        this.cellsFitToPage = table.isCellsFitPage();
        this.tableFitToPage = table.isTableFitsPage();
        if (!Float.isNaN(table.getOffset())) {
            this.offset = (int)(table.getOffset() * 2.0f);
        }
    }

    private void importTable(PdfPTable table) {
        this.rows = new ArrayList();
        this.tableWidthPercent = table.getWidthPercentage();
        this.proportionalWidths = table.getAbsoluteWidths();
        this.cellPadding = (float)((double)table.spacingAfter() * 20.0);
        this.cellSpacing = (float)((double)table.spacingAfter() * 20.0);
        this.alignment = table.getHorizontalAlignment();
        int i = 0;
        Iterator rowIterator = table.getRows().iterator();
        while (rowIterator.hasNext()) {
            this.rows.add(new RtfRow(this.document, this, (PdfPRow)rowIterator.next(), i));
            ++i;
        }
        for (i = 0; i < this.rows.size(); ++i) {
            ((RtfRow)this.rows.get(i)).handleCellSpanning();
            ((RtfRow)this.rows.get(i)).cleanRow();
        }
        this.headerRows = table.getHeaderRows();
        this.cellsFitToPage = table.getKeepTogether();
        this.tableFitToPage = table.getKeepTogether();
    }

    public void writeContent(OutputStream result) throws IOException {
        if (!this.inHeader) {
            if (this.offset != -1) {
                result.write(RtfFont.FONT_SIZE);
                result.write(this.intToByteArray(this.offset));
            }
            result.write(RtfParagraph.PARAGRAPH);
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            RtfElement re = (RtfElement)this.rows.get(i);
            re.writeContent(result);
        }
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
    }

    protected int getAlignment() {
        return this.alignment;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    protected float getCellPadding() {
        return this.cellPadding;
    }

    protected float getCellSpacing() {
        return this.cellSpacing;
    }

    protected float[] getProportionalWidths() {
        return (float[])this.proportionalWidths.clone();
    }

    protected float getTableWidthPercent() {
        return this.tableWidthPercent;
    }

    protected ArrayList getRows() {
        return this.rows;
    }

    protected boolean getCellsFitToPage() {
        return this.cellsFitToPage;
    }

    protected boolean getTableFitToPage() {
        return this.tableFitToPage;
    }

    protected int getHeaderRows() {
        return this.headerRows;
    }
}

