/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.test.deployment;

import java.util.Collection;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessDefinitionQuery;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.CollectionAssertions;

public class Bpmn2DeploymentTest
extends JbpmTestCase {
    private static final String TEST_PROCESS_ONLY_ID = "<definitions>  <process id='myProcess' >    <startEvent id='start'/>    <sequenceFlow id='flow1' sourceRef='start' targetRef='end' />    <endEvent id='end'/>  </process></definitions>";
    private static final String TEST_PROCESS_ONLY_NAME = "<definitions>  <process name='myProcess' >    <startEvent id='start'/>    <sequenceFlow id='flow1' sourceRef='start' targetRef='end' />    <endEvent id='end'/>  </process></definitions>";
    private static final String TEST_PROCESS_ID_AND_NAME = "<definitions>  <process id='myProcess' name='myFirstProcess'>    <startEvent id='start'/>    <sequenceFlow id='flow1' sourceRef='start' targetRef='end' />    <endEvent id='end'/>  </process></definitions>";

    public void testDeployProcessWithOnlyName() {
        try {
            this.deployBpmn2XmlString(TEST_PROCESS_ONLY_NAME);
            Bpmn2DeploymentTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testDeployProcessWithOnlyId() {
        this.deployBpmn2XmlString(TEST_PROCESS_ONLY_ID);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("myProcess");
        Bpmn2DeploymentTest.assertNotNull((Object)processInstance);
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testDeployProcessWithIdAndName() {
        this.deployBpmn2XmlString(TEST_PROCESS_ID_AND_NAME);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("myFirstProcess");
        Bpmn2DeploymentTest.assertNotNull((Object)processInstance);
        this.assertProcessInstanceEnded(processInstance);
        try {
            this.executionService.startProcessInstanceByKey("myProcess");
            Bpmn2DeploymentTest.fail();
        }
        catch (JbpmException e) {
            Bpmn2DeploymentTest.assertTrue((boolean)e.getMessage().contains("no process definition with key"));
        }
    }

    public void testRedeployProcessWithOnlyId() {
        this.deployBpmn2XmlString(TEST_PROCESS_ONLY_ID);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("myProcess");
        List definitions = query.list();
        Bpmn2DeploymentTest.assertEquals((int)1, (int)definitions.size());
        this.deployBpmn2XmlString(TEST_PROCESS_ONLY_ID);
        query.orderAsc("versionProperty.longValue");
        definitions = query.list();
        Bpmn2DeploymentTest.assertEquals((int)2, (int)definitions.size());
        Bpmn2DeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)definitions.get(0)).getVersion());
        Bpmn2DeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)definitions.get(1)).getVersion());
        List definitionsByName = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("myProcess").list();
        CollectionAssertions.assertContainsSameElements((Collection)definitions, (Collection)definitionsByName);
    }

    public void testRedeployProcessWithIdAndName() {
        this.deployBpmn2XmlString(TEST_PROCESS_ID_AND_NAME);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("myProcess");
        List definitions = query.list();
        Bpmn2DeploymentTest.assertEquals((int)1, (int)definitions.size());
        this.deployBpmn2XmlString(TEST_PROCESS_ID_AND_NAME);
        query.orderAsc("versionProperty.longValue");
        definitions = query.list();
        Bpmn2DeploymentTest.assertEquals((int)2, (int)definitions.size());
        Bpmn2DeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)definitions.get(0)).getVersion());
        Bpmn2DeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)definitions.get(1)).getVersion());
        List definitionsByKey = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("myFirstProcess").list();
        CollectionAssertions.assertContainsSameElements((Collection)definitions, (Collection)definitionsByKey);
    }
}

