/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.subprocess;

import java.util.HashMap;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class DynamicSubProcessTest
extends JbpmTestCase {
    private static final String SUB_PROCESS = "<process name='SubProcessReview'>  <start>    <transition to='get approval'/>  </start>  <task name='get approval' assignee='johndoe'>    <transition name='ok' to='ok'/>    <transition name='nok' to='nok'/>    <transition name='reject' to='reject'/>  </task>  <end name='ok' />  <end name='nok' />  <end name='reject' /></process>";
    private static final String MAIN_PROCESS_SUB_EL = "<process name='mainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-key='#{dynamic_subprocess}'>    <transition name='ok' to='next step'/>    <transition name='nok' to='update'/>    <transition name='reject' to='close'/>  </sub-process>  <state name='next step'/>  <state name='update'/>  <end name='close'/></process>";
    private static final String MAIN_PROCESS_SUB_EL_ID = "<process name='mainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-id='#{dynamic_subprocess}'>    <transition name='ok' to='next step'/>    <transition name='nok' to='update'/>    <transition name='reject' to='close'/>  </sub-process>  <state name='next step'/>  <state name='update'/>  <end name='close'/></process>";
    private static final String MAIN_PROCESS_SUB_ID = "<process name='mainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-id='SubProcessReview-1'>    <transition name='ok' to='next step'/>    <transition name='nok' to='update'/>    <transition name='reject' to='close'/>  </sub-process>  <state name='next step'/>  <state name='update'/>  <end name='close'/></process>";

    public void testDynamicSubProcess() {
        this.deployJpdlXmlString(SUB_PROCESS);
        this.deployJpdlXmlString(MAIN_PROCESS_SUB_EL);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("dynamic_subprocess", "SubProcessReview");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess", vars);
        Task task = (Task)this.taskService.findPersonalTasks("johndoe").get(0);
        this.taskService.completeTask(task.getId(), "reject");
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testDynamicSubProcessNotFound() {
        String expectedError = "Subprocess 'DOES_NOT_EXIST' could not be found.";
        this.deployJpdlXmlString(SUB_PROCESS);
        this.deployJpdlXmlString(MAIN_PROCESS_SUB_EL);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("dynamic_subprocess", "DOES_NOT_EXIST");
        try {
            ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess", vars);
            DynamicSubProcessTest.fail((String)("Should not happen, error expected: " + expectedError));
        }
        catch (JbpmException je) {
            DynamicSubProcessTest.assertEquals((String)expectedError, (String)je.getMessage());
        }
    }

    public void testDynamicSubProcessWrongProperty() {
        String expectedError = "Subprocess key '#{dynamic_subprocess}' could not be resolved.";
        this.deployJpdlXmlString(SUB_PROCESS);
        this.deployJpdlXmlString(MAIN_PROCESS_SUB_EL);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("WRONG_PROPERTY", "VALUE_DOES_NOT_MATTER");
        try {
            ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess", vars);
            DynamicSubProcessTest.fail((String)("Should not happen, error expected: " + expectedError));
        }
        catch (JbpmException je) {
            DynamicSubProcessTest.assertEquals((String)expectedError, (String)je.getMessage());
        }
    }

    public void testDynamicSubProcessWithId() {
        this.deployJpdlXmlString(SUB_PROCESS);
        this.deployJpdlXmlString(MAIN_PROCESS_SUB_EL_ID);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("dynamic_subprocess", "SubProcessReview-1");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess", vars);
        Task task = (Task)this.taskService.findPersonalTasks("johndoe").get(0);
        this.taskService.completeTask(task.getId(), "reject");
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testSubProcessWithId() {
        this.deployJpdlXmlString(SUB_PROCESS);
        this.deployJpdlXmlString(MAIN_PROCESS_SUB_ID);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess");
        Task task = (Task)this.taskService.findPersonalTasks("johndoe").get(0);
        this.taskService.completeTask(task.getId(), "reject");
        this.assertProcessInstanceEnded(processInstance);
    }
}

