/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.task;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryTask;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskReassignTest
extends JbpmTestCase {
    public void testReassignHistory() {
        this.deployJpdlXmlString("<process name='ReassignTest'>  <start>    <transition to='write email'/>  </start>  <task name='write email' assignee='shekharv'>    <transition to='end'/>  </task>  <end name='end'/></process>");
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("ReassignTest");
        List tasks = this.taskService.findPersonalTasks("shekharv");
        TaskReassignTest.assertTrue((tasks.size() == 1 ? 1 : 0) != 0);
        String taskId = ((Task)tasks.get(0)).getId();
        this.taskService.assignTask(taskId, "johndoe");
        List tasksAfterReassignment = this.taskService.findPersonalTasks("shekharv");
        TaskReassignTest.assertTrue((String)"shekharv should not have any tasks.", (tasksAfterReassignment.size() == 0 ? 1 : 0) != 0);
        List tasksForNewAssignee = this.taskService.findPersonalTasks("johndoe");
        TaskReassignTest.assertTrue((String)"johndoe should have 1 task.", (tasksForNewAssignee.size() == 1 ? 1 : 0) != 0);
        TaskReassignTest.assertEquals((String)"johndoe", (String)this.taskService.getTask(taskId).getAssignee());
        this.taskService.completeTask(taskId);
        HistoryTask historyTask = this.historyService.createHistoryTaskQuery().taskId(taskId).uniqueResult();
        TaskReassignTest.assertEquals((String)"John Doe completed the Task, but someone else got the credit", (String)"johndoe", (String)historyTask.getAssignee());
    }
}

