/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.QueryAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueryTest
extends JbpmTestCase {
    public void testQueryOutstandingTimers() {
        this.startTestProcessInstances(4);
        List timers = this.managementService.createJobQuery().timers().list();
        JobQueryTest.assertEquals((int)4, (int)timers.size());
    }

    public void testQueryBacklogMessages() {
        this.deployJpdlXmlString("<process name='MessagesQueryTest' >  <start>    <transition to='t' />  </start>  <state name='t' continue='async' /></process>");
        this.executionService.startProcessInstanceByKey("MessagesQueryTest");
        this.executionService.startProcessInstanceByKey("MessagesQueryTest");
        this.executionService.startProcessInstanceByKey("MessagesQueryTest");
        this.executionService.startProcessInstanceByKey("MessagesQueryTest");
        List jobs = this.managementService.createJobQuery().messages().list();
        JobQueryTest.assertEquals((int)4, (int)jobs.size());
    }

    public void testErrorMessages() {
        this.deployJpdlXmlString("<process name='ErrorMsgQueryTest' >  <start>    <transition to='t' />  </start>  <java name='t'         continue='async'         class='" + Dog.class.getName() + "'" + "        method='bark'>" + "  </java>" + "</process>");
        this.executionService.startProcessInstanceByKey("ErrorMsgQueryTest");
        this.executionService.startProcessInstanceByKey("ErrorMsgQueryTest");
        this.executionService.startProcessInstanceByKey("ErrorMsgQueryTest");
        List messages = this.managementService.createJobQuery().messages().list();
        JobQueryTest.assertEquals((int)3, (int)messages.size());
        try {
            this.managementService.executeJob(((Job)messages.get(0)).getId());
            JobQueryTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        List errorJobs = this.managementService.createJobQuery().exception(true).list();
        JobQueryTest.assertEquals((int)1, (int)errorJobs.size());
        this.assertTextPresent("wooof", ((Job)errorJobs.get(0)).getException());
        messages = this.managementService.createJobQuery().messages().exception(false).list();
        JobQueryTest.assertEquals((int)2, (int)messages.size());
    }

    public void testOrderByDueDate() {
        this.startTestProcessInstances(4);
        List jobsAsc = this.managementService.createJobQuery().orderAsc("dueDate").list();
        List jobsDesc = this.managementService.createJobQuery().orderDesc("dueDate").list();
        QueryAssertions.assertOrderIsNatural(Job.class, (String)"dueDate", (List)jobsAsc, (List)jobsDesc, (int)4);
    }

    public void testCount() {
        List<String> procInstIds = this.startTestProcessInstances(6);
        JobQueryTest.assertEquals((long)6L, (long)this.managementService.createJobQuery().count());
        JobQueryTest.assertEquals((long)6L, (long)this.managementService.createJobQuery().timers().count());
        for (String id : procInstIds) {
            JobQueryTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(id).count());
            JobQueryTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(id).timers().count());
        }
    }

    private List<String> startTestProcessInstances(int nrOfInstances) {
        this.deployJpdlXmlString("<process name='TimerQueryTest' >  <start>    <transition to='t' />  </start>  <state name='t'>    <transition name='timeout' to='t'>      <timer duedate='20 hours' />    </transition>  </state></process>");
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < nrOfInstances; ++i) {
            ids.add(this.executionService.startProcessInstanceByKey("TimerQueryTest").getId());
        }
        return ids;
    }

    public static class Dog
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void bark() {
            throw new RuntimeException("wooof");
        }
    }
}

