/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskService;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.api.task.Assignable;
import org.jbpm.api.task.AssignmentHandler;
import org.jbpm.api.task.Participation;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.test.JbpmTestCase;

public class AssignmentHandlerTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        String jpdl = "<?xml version=\"1.0\"?><process key=\"testProcess\" name=\"Test Process\" xmlns=\"http://jbpm.org/4.3/jpdl\">  <start g=\"67,236,48,48\" name=\"start1\">    <transition g=\"-43,-18\" name=\"to fork1\" to=\"fork1\"/>  </start>  <task g=\"255,144,92,52\" name=\"task1\" candidate-groups=\"firstGroup\">    <assignment-handler class=\"" + AutoAssignment.class.getName() + "\"/>" + "    <transition g=\"-41,-18\" name=\"to join1\" to=\"join1\"/>" + "  </task>" + "  <task g=\"258,334,92,52\" name=\"task2\" candidate-groups=\"secondGroup\">" + "    <assignment-handler class=\"" + AutoAssignment.class.getName() + "\"/>" + "    <transition g=\"-41,-18\" name=\"to join1\" to=\"join1\"/>" + "  </task>" + "  <task g=\"515,228,92,52\" name=\"task3\" candidate-groups=\"thirdGroup\">" + "    <assignment-handler class=\"" + AutoAssignment.class.getName() + "\"/>" + "    <transition g=\"-42,-18\" name=\"to end1\" to=\"end1\"/>" + "  </task>" + "  <end g=\"676,232,48,48\" name=\"end1\"/>" + "  <fork g=\"172,236,48,48\" name=\"fork1\">" + "    <transition g=\"-44,-18\" name=\"to task1\" to=\"task1\"/>" + "    <transition g=\"-44,-18\" name=\"to task2\" to=\"task2\"/>" + "  </fork>" + "  <join g=\"385,233,48,48\" name=\"join1\">" + "    <transition g=\"-44,-18\" name=\"to task3\" to=\"task3\"/>" + "  </join>" + "</process>";
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromString("testProcess.jpdl.xml", jpdl.toString()).deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testProcess() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("testProcess");
        String pid = processInstance.getId();
        List taskList = this.taskService.findPersonalTasks("firstUser");
        AssignmentHandlerTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        this.taskService.completeTask(task.getId());
        taskList = this.taskService.findPersonalTasks("secondUser");
        AssignmentHandlerTest.assertEquals((int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        this.taskService.completeTask(task.getId());
        taskList = this.taskService.findPersonalTasks("thirdUser");
        AssignmentHandlerTest.assertEquals((int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(pid);
        AssignmentHandlerTest.assertNull((Object)processInstance);
    }

    public static class AutoAssignment
    implements AssignmentHandler {
        private static final long serialVersionUID = 9063679883107908899L;

        public void assign(Assignable assignable, OpenExecution execution) throws Exception {
            Task task = (Task)assignable;
            List participations = ((TaskService)EnvironmentImpl.getFromCurrent(TaskService.class)).getTaskParticipations(task.getId());
            if (!participations.isEmpty()) {
                String groupId = ((Participation)participations.get(0)).getGroupId();
                assignable.setAssignee(groupId.substring(0, groupId.indexOf("Group")) + "User");
            }
        }
    }
}

