/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTaskTest
extends JbpmTestCase {
    public void testSubTasks() {
        Task task = this.taskService.newTask();
        task.setName("clean da house");
        String taskId = this.taskService.saveTask(task);
        Task subTask = this.taskService.newTask(taskId);
        subTask.setName("dishes");
        String dishesTaskId = this.taskService.saveTask(subTask);
        subTask = this.taskService.newTask(taskId);
        subTask.setName("laundry");
        String laundryTaskId = this.taskService.saveTask(subTask);
        subTask = this.taskService.newTask(taskId);
        subTask.setName("sweep floor");
        String sweepFloorTaskId = this.taskService.saveTask(subTask);
        List subTasks = this.taskService.getSubTasks(taskId);
        Set<String> subTaskNames = this.getTaskNames(subTasks);
        HashSet<String> expectedTaskNames = new HashSet<String>();
        expectedTaskNames.add("dishes");
        expectedTaskNames.add("laundry");
        expectedTaskNames.add("sweep floor");
        SubTaskTest.assertEquals(expectedTaskNames, subTaskNames);
        subTask = this.taskService.newTask(sweepFloorTaskId);
        subTask.setName("find broom");
        this.taskService.saveTask(subTask);
        subTask = this.taskService.newTask(sweepFloorTaskId);
        subTask.setName("find water");
        this.taskService.saveTask(subTask);
        subTask = this.taskService.newTask(sweepFloorTaskId);
        subTask.setName("scrub");
        this.taskService.saveTask(subTask);
        subTaskNames = this.getTaskNames(this.taskService.getSubTasks(taskId));
        expectedTaskNames = new HashSet();
        expectedTaskNames.add("dishes");
        expectedTaskNames.add("laundry");
        expectedTaskNames.add("sweep floor");
        SubTaskTest.assertEquals(expectedTaskNames, subTaskNames);
        subTaskNames = this.getTaskNames(this.taskService.getSubTasks(sweepFloorTaskId));
        expectedTaskNames = new HashSet();
        expectedTaskNames.add("find broom");
        expectedTaskNames.add("find water");
        expectedTaskNames.add("scrub");
        SubTaskTest.assertEquals(expectedTaskNames, subTaskNames);
        this.taskService.deleteTaskCascade(dishesTaskId);
        subTaskNames = this.getTaskNames(this.taskService.getSubTasks(taskId));
        expectedTaskNames = new HashSet();
        expectedTaskNames.add("laundry");
        expectedTaskNames.add("sweep floor");
        SubTaskTest.assertEquals(expectedTaskNames, subTaskNames);
        subTaskNames = this.getTaskNames(this.taskService.getSubTasks(sweepFloorTaskId));
        expectedTaskNames = new HashSet();
        expectedTaskNames.add("find broom");
        expectedTaskNames.add("find water");
        expectedTaskNames.add("scrub");
        SubTaskTest.assertEquals(expectedTaskNames, subTaskNames);
        this.taskService.deleteTaskCascade(laundryTaskId);
        this.taskService.deleteTaskCascade(sweepFloorTaskId);
        subTaskNames = this.getTaskNames(this.taskService.getSubTasks(taskId));
        expectedTaskNames = new HashSet();
        SubTaskTest.assertEquals(expectedTaskNames, subTaskNames);
        subTaskNames = this.getTaskNames(this.taskService.getSubTasks(sweepFloorTaskId));
        expectedTaskNames = new HashSet();
        SubTaskTest.assertEquals(expectedTaskNames, subTaskNames);
        this.taskService.deleteTaskCascade(taskId);
    }

    private Set<String> getTaskNames(List<Task> tasks) {
        HashSet<String> taskNames = new HashSet<String>();
        for (Task task : tasks) {
            taskNames.add(task.getName());
        }
        return taskNames;
    }
}

