/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.variables;

import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.test.JbpmTestCase;

public class VariableExpressionTest
extends JbpmTestCase {
    public void testExpression() {
        this.deployJpdlXmlString("<process name='theProcess'>  <start name='theStart'>    <transition to='incrementCounter' />  </start>  <custom name='incrementCounter' class='" + MyJavaActivity.class.getName() + "'>" + "   <transition to='decideToGoFurther' />" + "  </custom>" + "  <decision name='decideToGoFurther'>" + "    <transition to='waitHere'>" + "      <condition expr='#{counter == 10}' />" + "    </transition>" + "    <transition to='incrementCounter'>" + "      <condition expr='#{counter &lt; 10}' />" + "    </transition>" + "  </decision>" + "  <state name='waitHere'>" + "    <transition to='theEnd' />" + "  </state>" + "  <end name='theEnd' />" + "</process>");
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("counter", 0);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("theProcess", vars);
        this.assertActivityActive(processInstance.getId(), "waitHere");
        Integer counter = (Integer)this.executionService.getVariable(processInstance.getId(), "counter");
        VariableExpressionTest.assertEquals((Object)new Integer(10), (Object)counter);
    }

    public void testNullValueExpression() {
        this.deployJpdlXmlString("<process name='theProcess'>  <start name='theStart'>    <transition to='decideToGoFurther' />  </start>  <custom name='incrementCounter' class='" + MyJavaActivity.class.getName() + "'>" + "   <transition to='decideToGoFurther' />" + "  </custom>" + "  <decision name='decideToGoFurther'>" + "    <transition to='waitHere'>" + "      <condition expr='#{counter==null}' />" + "    </transition>" + "    <transition to='incrementCounter'>" + "      <condition expr='#{counter &lt; 10}' />" + "    </transition>" + "  </decision>" + "  <state name='waitHere'>" + "    <transition to='theEnd' />" + "  </state>" + "  <end name='theEnd' />" + "</process>");
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("counter", null);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("theProcess", vars);
        this.assertActivityActive(processInstance.getId(), "waitHere");
        Object value = this.executionService.getVariable(processInstance.getId(), "counter");
        VariableExpressionTest.assertEquals(null, (Object)value);
    }

    public void testMissingVariableExpression() {
        this.deployJpdlXmlString("<process name='theProcess'>  <start name='theStart'>    <transition to='decideToGoFurther' />  </start>  <custom name='incrementCounter' class='" + MyJavaActivity.class.getName() + "'>" + "   <transition to='decideToGoFurther' />" + "  </custom>" + "  <decision name='decideToGoFurther'>" + "    <transition to='waitHere'>" + "      <condition expr='#{counter==null}' />" + "    </transition>" + "    <transition to='incrementCounter'>" + "      <condition expr='#{counter &lt; 10}' />" + "    </transition>" + "  </decision>" + "  <state name='waitHere'>" + "    <transition to='theEnd' />" + "  </state>" + "  <end name='theEnd' />" + "</process>");
        HashMap vars = new HashMap();
        try {
            ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("theProcess", vars);
            VariableExpressionTest.fail((String)"Variable counter is not set, should fail");
        }
        catch (Exception e) {
            VariableExpressionTest.assertEquals((String)"Cannot resolve identifier 'counter'", (String)e.getMessage());
        }
    }

    public static class MyJavaActivity
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            Integer counter;
            Integer n = counter = (Integer)execution.getVariable("counter");
            Integer n2 = counter = Integer.valueOf(counter + 1);
            execution.setVariable("counter", (Object)counter);
        }
    }
}

