/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.LinkedList;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.jbpm.api.JbpmException;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.internal.log.Log;
import org.jbpm.jpdl.internal.activity.JpdlAutomaticActivity;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.descriptor.ListDescriptor;

public class HqlActivity
extends JpdlAutomaticActivity {
    private static final Log log = Log.getLog(HqlActivity.class.getName());
    private static final long serialVersionUID = 1L;
    protected String query;
    protected ListDescriptor parametersDescriptor;
    protected String resultVariableName;
    protected boolean isResultUnique;

    @Override
    public void perform(OpenExecution execution) {
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment == null) {
            throw new JbpmException("no environment for jpdl activity hql");
        }
        if (this.query.contains("case") || this.query.contains("when")) {
            Session session = environment.get(Session.class);
            String sql = null;
            SQLQuery query = null;
            sql = this.query;
            query = session.createSQLQuery(sql);
            if (!this.query.contains("cast(")) {
                List<String> columns = this.getAliasColumn(sql);
                for (String string : columns) {
                    query.addScalar(string, (Type)Hibernate.STRING);
                }
            }
            if (this.parametersDescriptor != null) {
                for (Descriptor valueDescriptor : this.parametersDescriptor.getValueDescriptors()) {
                    String parameterName = valueDescriptor.getName();
                    Object value = WireContext.create(valueDescriptor, (ScopeInstanceImpl)((Object)execution));
                    this.applyParameter((Query)query, parameterName, value);
                }
            }
            Object result = null;
            result = this.isResultUnique ? query.uniqueResult() : query.list();
            execution.setVariable(this.resultVariableName, result);
        } else {
            Session session = environment.get(Session.class);
            Query q = this.createQuery(session);
            if (this.parametersDescriptor != null) {
                for (Descriptor valueDescriptor : this.parametersDescriptor.getValueDescriptors()) {
                    String string = valueDescriptor.getName();
                    Object value = WireContext.create(valueDescriptor, (ScopeInstanceImpl)((Object)execution));
                    this.applyParameter(q, string, value);
                }
            }
            Object result = null;
            result = this.isResultUnique ? q.uniqueResult() : q.list();
            execution.setVariable(this.resultVariableName, result);
        }
    }

    protected Query createQuery(Session session) {
        return session.createQuery(this.query);
    }

    public void applyParameter(Query q, String parameterName, Object value) {
        if (value instanceof String) {
            q.setString(parameterName, (String)value);
        } else if (value instanceof Long) {
            q.setLong(parameterName, ((Long)value).longValue());
        } else {
            log.error("unknown hql parameter type: " + value.getClass().getName());
        }
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setParametersDescriptor(ListDescriptor parametersDescriptor) {
        this.parametersDescriptor = parametersDescriptor;
    }

    public void setResultUnique(boolean isResultUnique) {
        this.isResultUnique = isResultUnique;
    }

    public void setResultVariableName(String resultVariableName) {
        this.resultVariableName = resultVariableName;
    }

    public List<String> getAliasColumn(String sql) {
        int selectIndex = sql.indexOf("select");
        int fromIndex = sql.indexOf("from");
        String subsql = sql.substring(selectIndex, fromIndex);
        LinkedList<String> columns = new LinkedList<String>();
        if (subsql.contains(",")) {
            String[] str = subsql.split(",");
            int i = 0;
            while (i < str.length) {
                if (str[i].contains("case") && str[i].contains("when") && !str[i].contains("end")) {
                    int j = i + 1;
                    while (j < str.length) {
                        if (str[j].contains("end")) {
                            String s = str[i].concat(str[j]);
                            int asIndex = s.lastIndexOf("as");
                            String alias = s.substring(asIndex + 2, s.length());
                            String aliasColumn = alias.trim();
                            columns.add(aliasColumn);
                            break;
                        }
                        ++j;
                    }
                } else if (str[i].contains("case") && str[i].contains("when") && str[i].contains("end")) {
                    int asIndex = str[i].lastIndexOf("as");
                    String alias = str[i].substring(asIndex + 2, str[i].length());
                    String aliasColumn = alias.trim();
                    columns.add(aliasColumn);
                }
                ++i;
            }
        } else {
            int asIndex = subsql.lastIndexOf("as");
            String alias = subsql.substring(asIndex + 2, subsql.length());
            String aliasColumn = alias.trim();
            columns.add(aliasColumn);
        }
        return columns;
    }

    public static void main(String[] args) {
        String quer = "select (case when fp_kind=[\u91c7\u8d2d\u4e0e\u652f\u4ed8\u8d27\u6b3e] then [M6612] else (case when em_department in ([\u6d77\u5916\u8425\u9500\u4e2d\u5fc3],[\u56fd\u5185\u8425\u9500\u4e2d\u5fc3],[sssssss],[hahahahahahhah]) then [m1993] else [M5912] end ) end) as em_uscode,  (case when fp_kind =[\u91c7\u8d2d\u4e0e\u652f\u4ed8\u8d27\u6b3e] then [\u53f6\u6885] else (case when em_department in ([\u6d77\u5916\u8425\u9500\u4e2d\u5fc3]) then [\u674e\u9896] else [\u9648\u4e9a\u6797] end )end) as em_name  from FeePlease left join employee on em_name=fp_pleaseman where fp_code=key";
        List<Object> columns = new LinkedList();
        columns = new HqlActivity().getAliasColumn(quer);
        System.out.println(columns);
    }
}

