/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import org.jbpm.jpdl.internal.activity.JmsActivity;
import org.jbpm.jpdl.internal.activity.JpdlBinding;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.MapDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class JmsBinding
extends JpdlBinding {
    public static final String TAG = "jms";

    public JmsBinding() {
        super(TAG);
    }

    protected JmsBinding(String tagName) {
        super(tagName);
    }

    public Object parseJpdl(Element element, Parse parse, JpdlParser parser) {
        Element mapElement;
        Element objectElement;
        Element textElement;
        String acknowledge;
        JmsActivity jmsActivity = this.createJmsActivity();
        String connectionFactoryName = XmlUtil.attribute(element, "connection-factory", parse);
        jmsActivity.setConnectionFactoryName(connectionFactoryName);
        String destinationName = XmlUtil.attribute(element, "destination", parse);
        jmsActivity.setDestinationName(destinationName);
        Boolean transacted = XmlUtil.attributeBoolean(element, "transacted", parse);
        if (transacted != null) {
            jmsActivity.setTransacted(transacted);
        }
        if ((acknowledge = XmlUtil.attribute(element, "acknowledge")) != null) {
            if (acknowledge.equalsIgnoreCase("auto")) {
                jmsActivity.setAcknowledgeMode(1);
            } else if (acknowledge.equalsIgnoreCase("client")) {
                jmsActivity.setAcknowledgeMode(2);
            } else if (acknowledge.equalsIgnoreCase("dups-ok")) {
                jmsActivity.setAcknowledgeMode(3);
            } else {
                parse.addProblem("unknown jms acknowledge: '" + acknowledge + "'", element);
            }
        }
        if ((textElement = XmlUtil.element(element, "text")) != null) {
            String expressionText = XmlUtil.getContentText(textElement);
            jmsActivity.setType("text");
            Expression expression = Expression.create(expressionText, "uel-value");
            jmsActivity.setTextExpression(expression);
        }
        if ((objectElement = XmlUtil.element(element, "object")) != null) {
            jmsActivity.setType("object");
            String expressionText = XmlUtil.attribute(objectElement, "expr");
            Expression expression = Expression.create(expressionText, "uel-value");
            jmsActivity.setObjectExpression(expression);
        }
        if ((mapElement = XmlUtil.element(element, "map")) != null) {
            jmsActivity.setType("map");
            Descriptor descriptor = parser.parseDescriptor(mapElement, parse);
            if (descriptor instanceof MapDescriptor) {
                jmsActivity.setMapDescriptor((MapDescriptor)descriptor);
            } else {
                parse.addProblem("the parser did not return a descriptor of type MapDescriptor");
            }
        }
        return jmsActivity;
    }

    protected JmsActivity createJmsActivity() {
        return new JmsActivity();
    }
}

