/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.id.PropertyImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckDbCmd
implements Command<Object> {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(CheckDbCmd.class.getName());

    @Override
    public Object execute(Environment environment) throws Exception {
        Session session = EnvironmentImpl.getFromCurrent(Session.class);
        if (!PropertyImpl.propertiesTableExists(session)) {
            if (!CheckDbCmd.executionTableExists(session)) {
                throw new JbpmException("no jBPM DB schema: no JBPM4_EXECUTION table.   Run the create.jbpm.schema target first in the install tool.");
            }
            throw new JbpmException("jBPM DB schema not in sync with library version: no JBPM4_PROPERTIES table.   Run the upgrade target first in the install tool.");
        }
        Long nextDbid = PropertyImpl.getNextDbid(session);
        if (nextDbid == null) {
            PropertyImpl.setNextDbid(session, 1L);
        }
        String dbVersion = PropertyImpl.getDbVersion(session);
        log.info("jBPM version info: library[4.4-SNAPSHOT], schema[" + dbVersion + "]");
        if (dbVersion != null && !dbVersion.equals("4.4-SNAPSHOT")) {
            throw new JbpmException("jBPM DB schema version (" + dbVersion + ") differs from jBPM library version (" + "4.4-SNAPSHOT" + "): run the upgrade tool first.");
        }
        return null;
    }

    public static boolean executionTableExists(Session session) {
        try {
            session.createQuery("from " + ExecutionImpl.class.getName()).setMaxResults(1).uniqueResult();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

