/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.events;

import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.type.Variable;

public class VariableCreate
extends HistoryEvent {
    private static final long serialVersionUID = 1L;
    Variable variable;

    public VariableCreate(Variable variable) {
        this.variable = variable;
    }

    public void process() {
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        dbSession.save(this.variable);
        HistoryProcessInstanceImpl historyProcessInstance = null;
        ExecutionImpl processInstance = this.variable.getProcessInstance();
        if (processInstance != null) {
            long processInstanceDbid = processInstance.getDbid();
            historyProcessInstance = dbSession.get(HistoryProcessInstanceImpl.class, processInstanceDbid);
        }
        HistoryTaskImpl historyTask = null;
        TaskImpl task = this.variable.getTask();
        if (task != null) {
            long taskDbid = task.getDbid();
            historyTask = dbSession.get(HistoryTaskImpl.class, taskDbid);
        }
        HistoryVariableImpl historyVariable = new HistoryVariableImpl(historyProcessInstance, historyTask, this.variable);
        dbSession.save(historyVariable);
    }

    public Variable getVariable() {
        return this.variable;
    }
}

