/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.job.Message;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.session.MessageSession;

public class JmsMessageSession
implements MessageSession {
    private static final long serialVersionUID = 1L;
    DbSession dbSession;
    Session jmsSession;
    Destination jmsDestination;

    public void send(Message message) {
        try {
            this.dbSession.save(message);
            javax.jms.Message jmsMessage = this.jmsSession.createMessage();
            MessageProducer messageProducer = this.jmsSession.createProducer(this.jmsDestination);
            try {
                messageProducer.send(jmsMessage);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't send jms message: " + e.getMessage(), e);
            }
            finally {
                messageProducer.close();
            }
            jmsMessage.setStringProperty("jobId", message.getId());
        }
        catch (JMSException e) {
            throw new JbpmException("couldn't send jms message", e);
        }
    }

    public void close() {
    }
}

