/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.model.VariableOutDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableOutDefinitionSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<VariableOutDefinitionImpl> variableOutDefinitions;

    public void processOutVariables(ExecutionImpl outerExecution, ScopeInstanceImpl innerScopeInstance) {
        if (this.hasVariableOutDefinitions()) {
            for (VariableOutDefinitionImpl variableOutDefinition : this.variableOutDefinitions) {
                String variableName = variableOutDefinition.getName();
                if (variableName == null) continue;
                String expression = variableOutDefinition.getExpression();
                String language = variableOutDefinition.getLanguage();
                Object value = Expression.create(expression, language).evaluateInScope(innerScopeInstance);
                outerExecution.setVariable(variableName, value);
            }
        }
    }

    public boolean hasVariableOutDefinitions() {
        return this.variableOutDefinitions != null && !this.variableOutDefinitions.isEmpty();
    }

    public List<VariableOutDefinitionImpl> getVariableOutDefinitions() {
        if (this.variableOutDefinitions == null) {
            return Collections.emptyList();
        }
        return this.variableOutDefinitions;
    }

    public VariableOutDefinitionImpl createVariableOutDefinition() {
        VariableOutDefinitionImpl variableOutDefinition = new VariableOutDefinitionImpl();
        if (this.variableOutDefinitions == null) {
            this.variableOutDefinitions = new ArrayList<VariableOutDefinitionImpl>();
        }
        this.variableOutDefinitions.add(variableOutDefinition);
        return variableOutDefinition;
    }
}

