/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.server.integration.ProcessManagement;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.RepositoryService;
import org.jbpm.integration.console.JBPMIntegration;
import org.jbpm.integration.console.ModelAdaptor;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessManagementImpl
extends JBPMIntegration
implements ProcessManagement {
    public List<ProcessDefinitionRef> getProcessDefinitions() {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        ArrayList<ProcessDefinitionRef> results = new ArrayList<ProcessDefinitionRef>();
        List activePds = repositoryService.createProcessDefinitionQuery().orderAsc("idProperty.objectName").list();
        for (ProcessDefinition processDefinition : activePds) {
            results.add(ModelAdaptor.adoptDefinition(processDefinition));
        }
        return results;
    }

    public ProcessDefinitionRef getProcessDefinition(String procDefId) {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(procDefId).uniqueResult();
        return ModelAdaptor.adoptDefinition(processDefinition);
    }

    public List<ProcessDefinitionRef> removeProcessDefinition(String procDefId) {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(procDefId).uniqueResult();
        if (processDefinition != null) {
            repositoryService.deleteDeploymentCascade(processDefinition.getDeploymentId());
        }
        return this.getProcessDefinitions();
    }

    public List<ProcessInstanceRef> getProcessInstances(String procDefId) {
        ExecutionService execService = this.processEngine.getExecutionService();
        List processInstances = execService.createProcessInstanceQuery().processDefinitionId(procDefId).list();
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(procDefId).uniqueResult();
        List<ProcessInstanceRef> results = this.adoptProcessInstances(processInstances, processDefinition);
        return results;
    }

    private List<ProcessInstanceRef> adoptProcessInstances(List<ProcessInstance> processInstances, ProcessDefinition processDefinition) {
        ArrayList<ProcessInstanceRef> results = new ArrayList<ProcessInstanceRef>();
        for (ProcessInstance processInstance : processInstances) {
            if (processInstance.isEnded() || !processInstance.getIsProcessInstance()) continue;
            ((ExecutionImpl)processInstance).setProcessDefinition((ProcessDefinitionImpl)processDefinition);
            results.add(ModelAdaptor.adoptExecution((Execution)processInstance));
        }
        return results;
    }

    public ProcessInstanceRef getProcessInstance(String instanceId) {
        ExecutionService execService = this.processEngine.getExecutionService();
        ProcessInstance processInstance = execService.createProcessInstanceQuery().processInstanceId(instanceId).uniqueResult();
        return ModelAdaptor.adoptExecution((Execution)processInstance);
    }

    public Map<String, Object> getInstanceData(String instanceId) {
        HashMap<String, Object> data = new HashMap();
        ExecutionService execService = this.processEngine.getExecutionService();
        Set keys = execService.getVariableNames(instanceId);
        data = execService.getVariables(instanceId, keys);
        return data;
    }

    public void setInstanceData(String instanceId, Map<String, Object> data) {
        throw new RuntimeException("Not implemented");
    }

    public ProcessInstanceRef newInstance(String definitionId) {
        ExecutionService execService = this.processEngine.getExecutionService();
        ProcessInstance exec = execService.startProcessInstanceById(definitionId);
        return ModelAdaptor.adoptExecution((Execution)exec);
    }

    public ProcessInstanceRef newInstance(String definitionId, Map<String, Object> processVars) {
        ExecutionService execService = this.processEngine.getExecutionService();
        ProcessInstance exec = execService.startProcessInstanceById(definitionId, processVars);
        return ModelAdaptor.adoptExecution((Execution)exec);
    }

    public void endInstance(String instanceId, ProcessInstanceRef.RESULT result) {
        ExecutionService execService = this.processEngine.getExecutionService();
        Execution exec = execService.findExecutionById(instanceId);
        if (null == exec) {
            throw new IllegalArgumentException("No such execution with id " + instanceId);
        }
        ProcessInstanceRef.RESULT actualResult = result != null ? result : ProcessInstanceRef.RESULT.COMPLETED;
        execService.endProcessInstance(instanceId, actualResult.toString());
    }

    public void deleteInstance(String instanceId) {
        ExecutionService execService = this.processEngine.getExecutionService();
        Execution exec = execService.findExecutionById(instanceId);
        if (null == exec) {
            throw new IllegalArgumentException("No such execution with id " + instanceId);
        }
        execService.deleteProcessInstance(instanceId);
    }

    public void setProcessState(String executionId, ProcessInstanceRef.STATE nextState) {
        throw new RuntimeException("Not implemented");
    }

    public void signalExecution(String executionId, String signal) {
        ExecutionService execService = this.processEngine.getExecutionService();
        if (null == signal) {
            execService.signalExecutionById(executionId);
        } else {
            execService.signalExecutionById(executionId, signal);
        }
    }

    public void deploy(String fileName, String contentType, InputStream deployment) {
        throw new RuntimeException("Not implemented");
    }
}

