/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk;

import com.seewo.open.sdk.HttpRequest;
import com.seewo.open.sdk.OpenApiParam;
import com.seewo.open.sdk.OpenApiResult;
import com.seewo.open.sdk.util.CodecUtils;
import java.util.Map;

public abstract class OpenApiRequest<P extends OpenApiParam, R extends OpenApiResult>
implements HttpRequest {
    private String serverUrl;
    private P bizModel;
    private String httpMethod;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private String path;
    private String permissionId;

    @Override
    public String getContentType() {
        return "application/json;charset=utf-8";
    }

    @Override
    public void setContentType(String contentType) {
        throw new UnsupportedOperationException();
    }

    public void setBizModel(P bizModel) {
        this.bizModel = bizModel;
    }

    public P getBizModel() {
        if (this.bizModel == null) {
            throw new UnsupportedOperationException("\u8bf7\u5148\u8c03\u7528 setBizModel \u8bbe\u7f6e\u4e1a\u52a1\u53c2\u6570\u5bf9\u8c61");
        }
        return this.bizModel;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setBody(byte[] body) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addHeader(String key, String value) {
        ((OpenApiParam)this.getBizModel()).getHeaders().put(key, value);
    }

    @Override
    public void addPathVariable(String key, String value) {
        ((OpenApiParam)this.getBizModel()).getPathVariables().put(key, value);
    }

    @Override
    public void addQuery(String key, String value) {
        ((OpenApiParam)this.getBizModel()).getQueries().put(key, value);
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public byte[] getBody() {
        P p = this.getBizModel();
        if (((OpenApiParam)p).getBody() == null || ((OpenApiParam)p).getBody().equals("")) {
            return new byte[0];
        }
        return CodecUtils.string2byte(((OpenApiParam)p).getBody());
    }

    @Override
    public String getQueryString() {
        Map<String, String> queries = this.getQueries();
        if (queries == null || queries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("?");
        for (Map.Entry<String, String> entry : queries.entrySet()) {
            sb.append(entry.getKey()).append("=").append(CodecUtils.urlEncode(entry.getValue())).append("&");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    @Override
    public Map<String, String> getQueries() {
        return ((OpenApiParam)this.getBizModel()).getQueries();
    }

    @Override
    public Map<String, String> getHeaders() {
        return ((OpenApiParam)this.getBizModel()).getHeaders();
    }

    @Override
    public Map<String, String> getPathVariables() {
        return ((OpenApiParam)this.getBizModel()).getPathVariables();
    }

    public String getPermissionId() {
        return this.permissionId;
    }

    public void setPermissionId(String permissionId) {
        this.permissionId = permissionId;
    }

    public abstract Class<R> getResponseClass();

    public abstract Class<P> getDomainClass();

    public String toString() {
        return "OpenApiRequest{serverUrl='" + this.serverUrl + '\'' + ", bizModel=" + this.bizModel + ", httpMethod='" + this.httpMethod + '\'' + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", path='" + this.path + '\'' + ", permissionId='" + this.permissionId + '\'' + '}';
    }
}

