/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk;

import com.seewo.open.sdk.HttpResponse;
import com.seewo.open.sdk.ParameterPosition;
import com.seewo.open.sdk.fastjson.JSON;
import com.seewo.open.sdk.util.CodecUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

public abstract class OpenApiResult {
    @ParameterPosition.ResponseArray(element=String[].class)
    private Field[] declaredFields;
    private String reqId;
    private String message;
    private Integer statusCode;
    private String phrase;
    private Map<String, String> headers;
    private String body;

    public OpenApiResult(HttpResponse httpResponse) {
        this.statusCode = httpResponse.getStatusCode();
        this.phrase = httpResponse.getPhrase();
        this.reqId = httpResponse.getHeaders().get("x-sw-req-id");
        this.message = httpResponse.getHeaders().get("x-sw-message");
        this.headers = httpResponse.getHeaders();
        this.body = CodecUtils.byte2string(httpResponse.getBodyBuffer());
        for (Field field : this.declaredFields()) {
            Annotation annotation = field.getAnnotation(ParameterPosition.Header.class);
            if (annotation != null) {
                String key = annotation.value();
                String value = this.headers.get(key);
                this.setValueToField(field, value);
                continue;
            }
            annotation = field.getAnnotation(ParameterPosition.ResponseArray.class);
            if (annotation != null) {
                if (!field.getClass().isAssignableFrom(Collection.class)) continue;
                Class<?> element = ((ParameterPosition.ResponseArray)annotation).element();
                this.setValueToField(field, CodecUtils.parseJsonArray(this.body, element));
                continue;
            }
            this.setValueToField(field, JSON.parseObject(this.body, field.getType()));
        }
    }

    protected Field[] declaredFields() {
        if (this.declaredFields != null) {
            return this.declaredFields;
        }
        this.declaredFields = this.getClass().getDeclaredFields();
        return this.declaredFields;
    }

    private void setValueToField(Field field, Object value) {
        field.setAccessible(true);
        try {
            field.set(this, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public String getReqId() {
        return this.reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public String toString() {
        return this.getClass() + "{reqId='" + this.reqId + '\'' + ", message='" + this.message + '\'' + ", statusCode=" + this.statusCode + ", phrase='" + this.phrase + '\'' + ", headers=" + this.headers + "\r\n, body='" + this.body + '\'' + '}';
    }
}

