/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk.util;

import com.seewo.open.sdk.SeewoApiException;
import com.seewo.open.sdk.constant.SeewoErrorCode;
import com.seewo.open.sdk.util.Base64;
import com.seewo.open.sdk.util.SeewoStringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class SignUtils {
    private static final byte[] IV_BYTES = "0102030405060708".getBytes();
    private static final String AES = "AES";
    private static String intranetIp;
    private static final String MAC_HMAC_MD5 = "HmacMD5";

    private SignUtils() {
    }

    public static String getContentMD5(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes can not be null");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(bytes);
            byte[] md5Result = md.digest();
            return SignUtils.byte2hex(md5Result);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm MD5");
        }
    }

    public static void addParams(String key, String value, Map<String, String> params) {
        String existed = params.get(key);
        if (SeewoStringUtils.isEmptyEvenWhiteSpace(existed)) {
            params.put(key, value);
        } else {
            String sep = ",";
            String[] oldValues = existed.split(sep);
            Object[] newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
            Arrays.sort(newValues);
            StringBuilder sb = new StringBuilder();
            for (Object target : newValues) {
                sb.append((String)target).append(sep);
            }
            params.put(key, sb.substring(0, sb.length() - 1));
        }
    }

    public static String signRequest(Map<String, String> params, String secret, String signMethod) throws IOException {
        byte[] bytes;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if ("md5".equals(signMethod)) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (!SeewoStringUtils.areNotEmpty(new String[]{key, value})) continue;
            query.append((String)key).append(value);
        }
        if ("hmac".equals(signMethod)) {
            bytes = SignUtils.encryptHMAC(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = SignUtils.encryptMD5(query.toString());
        }
        return SignUtils.byte2hex(bytes);
    }

    private static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("utf-8"), MAC_HMAC_MD5);
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes("utf-8"));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static byte[] encryptMD5(String data) throws IOException {
        return SignUtils.encryptMD5(data.getBytes("utf-8"));
    }

    private static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String getIntranetIp() {
        if (intranetIp == null) {
            try {
                intranetIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                intranetIp = "127.0.0.1";
            }
        }
        return intranetIp;
    }

    public static String aesEncrypt(String content, byte[] encryptKey) throws SeewoApiException {
        try {
            return SignUtils.aesEncrypt(content.getBytes("utf-8"), encryptKey);
        }
        catch (Exception e) {
            throw new SeewoApiException(SeewoErrorCode.SEEWO_SIGN_ERROR, e);
        }
    }

    public static String aesDecrypt(String content, byte[] decryptKey) throws SeewoApiException {
        try {
            return new String(SignUtils.aesDecrypt(content.getBytes("utf-8"), decryptKey), "utf-8");
        }
        catch (Exception e) {
            throw new SeewoApiException(SeewoErrorCode.SEEWO_SIGN_ERROR, e);
        }
    }

    public static byte[] aesDecrypt(byte[] encryptBytes, byte[] decryptKey) throws SeewoApiException {
        IvParameterSpec iv = new IvParameterSpec(IV_BYTES);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(decryptKey, AES), iv);
            return cipher.doFinal(Base64.decode(encryptBytes));
        }
        catch (Exception e) {
            throw new SeewoApiException(SeewoErrorCode.SEEWO_SIGN_ERROR, e);
        }
    }

    public static String aesEncrypt(byte[] content, byte[] encryptKey) throws SeewoApiException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES);
            kgen.init(new SecureRandom(encryptKey));
            IvParameterSpec iv = new IvParameterSpec(IV_BYTES);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)new SecretKeySpec(encryptKey, AES), iv);
            return SignUtils.base64Encode(cipher.doFinal(content));
        }
        catch (Exception e) {
            throw new SeewoApiException(SeewoErrorCode.SEEWO_SIGN_ERROR, e);
        }
    }

    public static String base64Encode(byte[] src) throws SeewoApiException {
        try {
            return SignUtils.base64Encode(src, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SeewoApiException(SeewoErrorCode.SEEWO_SIGN_ERROR, e);
        }
    }

    public static String base64Encode(byte[] src, String charsetName) throws UnsupportedEncodingException {
        byte[] res = Base64.encodeToByte(src, false);
        return src != null ? new String(res, charsetName) : null;
    }

    public static String hmacMD5EncryptToBase64(String encryptText, byte[] encryptKey, int compressLen) throws SeewoApiException {
        try {
            return SignUtils.base64Encode(SignUtils.compress(SignUtils.hmacMD5Encrypt(encryptText, encryptKey), compressLen));
        }
        catch (Exception e) {
            throw new SeewoApiException(SeewoErrorCode.SEEWO_SIGN_ERROR, e);
        }
    }

    public static String hmacMD5EncryptToBase64(String encryptText, byte[] encryptKey) throws SeewoApiException {
        try {
            return SignUtils.base64Encode(SignUtils.hmacMD5Encrypt(encryptText, encryptKey));
        }
        catch (Exception e) {
            throw new SeewoApiException(SeewoErrorCode.SEEWO_SIGN_ERROR, e);
        }
    }

    public static byte[] hmacMD5Encrypt(String encryptText, byte[] encryptKey) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(encryptKey, MAC_HMAC_MD5);
        Mac mac = Mac.getInstance(MAC_HMAC_MD5);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes("utf-8");
        return mac.doFinal(text);
    }

    public static List<String> getSlideWindows(String input, int slideSize) {
        ArrayList<String> windows = new ArrayList<String>();
        int startIndex = 0;
        int endIndex = 0;
        int currentWindowSize = 0;
        String currentWindow = null;
        while (endIndex < input.length() || currentWindowSize > slideSize) {
            boolean startsWithLetterOrDigit = currentWindow == null ? false : SignUtils.isLetterOrDigit(currentWindow.charAt(0));
            if (endIndex == input.length() && !startsWithLetterOrDigit) break;
            if (currentWindowSize == slideSize && !startsWithLetterOrDigit && SignUtils.isLetterOrDigit(input.charAt(endIndex))) {
                currentWindow = input.substring(startIndex, ++endIndex);
                currentWindowSize = 5;
            } else {
                if (endIndex != 0) {
                    currentWindowSize = startsWithLetterOrDigit ? --currentWindowSize : (currentWindowSize -= 2);
                    ++startIndex;
                }
                while (currentWindowSize < slideSize && endIndex < input.length()) {
                    char currentChar = input.charAt(endIndex);
                    currentWindowSize = SignUtils.isLetterOrDigit(currentChar) ? ++currentWindowSize : (currentWindowSize += 2);
                    ++endIndex;
                }
                currentWindow = input.substring(startIndex, endIndex);
            }
            windows.add(currentWindow);
        }
        return windows;
    }

    private static boolean isLetterOrDigit(char x) {
        return '\u0000' <= x && x <= '\u007f';
    }

    private static byte[] compress(byte[] input, int toLength) {
        int i;
        if (toLength < 0) {
            return null;
        }
        byte[] output = new byte[toLength];
        for (i = 0; i < output.length; ++i) {
            output[i] = 0;
        }
        for (i = 0; i < input.length; ++i) {
            int index_output;
            int n = index_output = i % toLength;
            output[n] = (byte)(output[n] ^ input[i]);
        }
        return output;
    }
}

