package com.seewo.open.sdk.util;

import java.util.*;

/**
 * @author Jiaze
 * @date 2017-11-8 16:01
 * @since 0.0.1
 */
public class SeewoStringUtils {

    private SeewoStringUtils() {
    }

    public static boolean areNotEmpty(String... values) {
        for (String str : values) {
            if (isEmptyEvenWhiteSpace(str)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isEmptyEvenWhiteSpace(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String[] tokenizeToStringArray(
            String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {

        if (str == null) {
            return null;
        }

        StringTokenizer st = new StringTokenizer(str, delimiters);
        List<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (!ignoreEmptyTokens || token.length() > 0) {
                tokens.add(token);
            }
        }
        return toStringArray(tokens);
    }

    /**
     * Copy the given {@code Collection} into a {@code String} array.
     * <p>The {@code Collection} must contain {@code String} elements only.
     * @param collection the {@code Collection} to copy
     * @return the {@code String} array ({@code null} if the supplied
     * {@code Collection} was {@code null})
     */
    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }

        return collection.toArray(new String[collection.size()]);
    }

    public static String setJoin(Set<String> set, String separator) {
        if(set.isEmpty()) return "";
        StringBuilder stringBuilder = new StringBuilder();
        for (String entry : set) {
            stringBuilder.append(entry).append(separator);
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    public static String mapJoin(Map<String, String> map, String connector, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append(connector).append(entry.getValue()).append(separator);
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }
}
