/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.List;
import org.jbpm.bpmn.flownodes.ActivityResource;
import org.jbpm.bpmn.flownodes.BpmnActivity;
import org.jbpm.bpmn.flownodes.BpmnBinding;
import org.jbpm.bpmn.flownodes.ManualTaskActivity;
import org.jbpm.bpmn.model.BpmnProcessDefinition;
import org.jbpm.bpmn.parser.BpmnParser;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class AbstractTaskBinding
extends BpmnBinding {
    protected static final String HUMAN_PERFORMER = "humanPerformer";
    protected static final String PERFORMER = "performer";
    protected static final String POTENTIAL_OWNER = "potentialOwner";

    public AbstractTaskBinding(String tagName) {
        super(tagName);
    }

    public Object parse(Element element, Parse parse, BpmnParser bpmnParser) {
        ManualTaskActivity manualTaskActivity = new ManualTaskActivity();
        manualTaskActivity.setDefault(this.getDefault());
        return manualTaskActivity;
    }

    protected void addActivityResources(TaskDefinitionImpl taskDefinition, BpmnActivity taskActivity, Element element, Parse parse) {
        Element humanPerformer;
        Element performer = XmlUtil.element(element, PERFORMER);
        if (performer != null) {
            taskActivity.addActivityResource(this.addPerformer(taskDefinition, PERFORMER, performer, parse));
        }
        if ((humanPerformer = XmlUtil.element(element, HUMAN_PERFORMER)) != null) {
            taskActivity.addActivityResource(this.addPerformer(taskDefinition, HUMAN_PERFORMER, humanPerformer, parse));
        }
        List<Element> potentialOwners = XmlUtil.elements(element, POTENTIAL_OWNER);
        for (Element potentialOwner : potentialOwners) {
            taskActivity.addActivityResource(this.addPerformer(taskDefinition, POTENTIAL_OWNER, potentialOwner, parse));
        }
    }

    private ActivityResource addPerformer(TaskDefinitionImpl taskDefinition, String type, Element performer, Parse parse) {
        String resourceRef = XmlUtil.attribute(performer, "resourceRef", parse);
        BpmnProcessDefinition bpmnProcessDefinition = parse.contextStackFind(BpmnProcessDefinition.class);
        ActivityResource activityResource = new ActivityResource();
        activityResource.setResourceRef(bpmnProcessDefinition.getResource(resourceRef));
        String scope = XmlUtil.attribute(performer, "jbpm:type");
        Element rae = XmlUtil.element(performer, "resourceAssignmentExpression");
        if (rae != null) {
            String formalExpression = XmlUtil.element(rae, "formalExpression", parse).getTextContent().trim();
            String lang = XmlUtil.attribute(rae, "language");
            Expression expression = Expression.create(formalExpression, lang);
            if (PERFORMER.equals(type) || HUMAN_PERFORMER.equals(type)) {
                taskDefinition.setAssigneeExpression(expression);
            } else if (POTENTIAL_OWNER.equals(type) && "user".equals(scope)) {
                taskDefinition.setCandidateUsersExpression(expression);
            } else {
                taskDefinition.setCandidateGroupsExpression(expression);
            }
        }
        return activityResource;
    }
}

