/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.Map;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.bpmn.flownodes.BpmnExternalActivity;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskActivityStart;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTaskActivity
extends BpmnExternalActivity {
    private static final long serialVersionUID = 1L;
    protected TaskDefinitionImpl taskDefinition;

    @Override
    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    @Override
    public void execute(ExecutionImpl execution) {
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = dbSession.createTask();
        task.setTaskDefinition(this.taskDefinition);
        task.setExecution(execution);
        task.setProcessInstance(execution.getProcessInstance());
        task.setSignalling(true);
        Expression assigneeExpression = this.taskDefinition.getAssigneeExpression();
        if (assigneeExpression != null) {
            Object assignee = assigneeExpression.evaluate(execution);
            task.setAssignee(assignee != null ? assignee.toString() : null);
        }
        if (this.taskDefinition.getName() != null) {
            task.setName(this.taskDefinition.getName());
        } else {
            task.setName(execution.getActivityName());
        }
        Expression descriptionExpression = this.taskDefinition.getDescription();
        if (descriptionExpression != null) {
            String description = (String)descriptionExpression.evaluate(task);
            task.setDescription(description);
        }
        task.setPriority(this.taskDefinition.getPriority());
        task.setFormResourceName(this.taskDefinition.getFormResourceName());
        dbSession.save(task);
        execution.initializeAssignments(this.taskDefinition, task);
        HistoryEvent.fire(new TaskActivityStart(task), execution);
        execution.waitForSignal();
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        this.signal((ExecutionImpl)execution, signalName, parameters);
    }

    public void signal(ExecutionImpl execution, String signalName, Map<String, ?> parameters) throws Exception {
        ActivityImpl activity = execution.getActivity();
        if (parameters != null) {
            execution.setVariables(parameters);
        }
        execution.fire(signalName, activity);
        DbSession taskDbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = taskDbSession.findTaskByExecution(execution);
        if (task != null) {
            task.setSignalling(false);
        }
        execution.setVariable("jbpm_outcome", signalName);
        this.proceed(execution, this.findOutgoingSequenceFlow(execution, true));
    }

    public TaskDefinitionImpl getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(TaskDefinitionImpl taskDefinition) {
        this.taskDefinition = taskDefinition;
    }
}

