/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.history.HistoryTask;
import org.jbpm.pvm.internal.history.model.HistoryDetailImpl;
import org.jbpm.pvm.internal.history.model.HistoryPriorityUpdateImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskAssignmentImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskDuedateUpdateImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.pvm.internal.util.EqualsUtil;

public class HistoryTaskImpl
implements Serializable,
HistoryTask {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected String executionId;
    protected String assignee;
    protected String state;
    protected String outcome;
    protected int priority;
    protected Date duedate;
    protected Date createTime;
    protected Date endTime;
    protected long duration;
    protected int nextDetailIndex = 1;
    protected Set<HistoryTaskImpl> subTasks = new HashSet<HistoryTaskImpl>();
    protected Set<HistoryVariableImpl> historyVariables;
    protected Set<HistoryDetailImpl> details = new HashSet<HistoryDetailImpl>();

    public HistoryTaskImpl() {
    }

    public HistoryTaskImpl(TaskImpl task) {
        this.dbid = task.getDbid();
        this.assignee = task.getAssignee();
        this.priority = task.getPriority();
        this.duedate = task.getDuedate();
        this.createTime = Clock.getTime();
    }

    public void updated(TaskImpl task) {
        if (this.assignee == null && task.getAssignee() != null || this.assignee != null && !this.assignee.equals(task.getAssignee())) {
            this.addDetail(new HistoryTaskAssignmentImpl(this.assignee, task.getAssignee()));
            this.assignee = task.getAssignee();
        }
        if (this.priority != task.getPriority()) {
            this.addDetail(new HistoryPriorityUpdateImpl(this.priority, task.getPriority()));
            this.priority = task.getPriority();
        }
        if (this.duedate == null && task.getDuedate() != null || this.duedate != null && !this.duedate.equals(task.getDuedate())) {
            this.addDetail(new HistoryTaskDuedateUpdateImpl(this.duedate, task.getDuedate()));
            this.duedate = task.getDuedate();
        }
    }

    public void addDetail(HistoryDetailImpl detail) {
        detail.setHistoryTask(this, this.nextDetailIndex);
        this.details.add(detail);
        ++this.nextDetailIndex;
    }

    public void addSubTask(HistoryTaskImpl historyTask) {
        this.subTasks.add(historyTask);
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String getId() {
        return Long.toString(this.dbid);
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.duration = endTime.getTime() - this.createTime.getTime();
    }

    public String getState() {
        return this.state;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }
}

