/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import org.jbpm.api.cmd.Command;
import org.jbpm.pvm.internal.env.EnvironmentFactory;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.svc.Interceptor;
import org.jbpm.pvm.internal.svc.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentInterceptor
extends Interceptor {
    protected EnvironmentFactory environmentFactory;
    protected Policy policy = Policy.REQUIRES;

    @Override
    public <T> T execute(Command<T> command) {
        if (this.isEnvironmentCreationNecessary()) {
            return this.executeInNewEnvironment(command);
        }
        return this.executeInExistingEnvironment(command);
    }

    protected <T> T executeInExistingEnvironment(Command<T> command) {
        return this.next.execute(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T executeInNewEnvironment(Command<T> command) {
        EnvironmentImpl environment = this.environmentFactory.openEnvironment();
        try {
            T t = this.next.execute(command);
            return t;
        }
        finally {
            environment.close();
        }
    }

    protected boolean isEnvironmentCreationNecessary() {
        return this.policy == Policy.REQUIRES_NEW || EnvironmentImpl.getCurrent() == null;
    }

    public EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public void setEnvironmentFactory(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }
}

