/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import org.jbpm.pvm.internal.svc.RetryInterceptor;
import org.jbpm.pvm.internal.tx.JtaRetryInterceptor;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.WireInterceptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class RetryInterceptorBinding
extends WireInterceptorBinding {
    public RetryInterceptorBinding() {
        super("retry-interceptor");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        RetryInterceptor retryInterceptor = null;
        String type = XmlUtil.attribute(element, "type");
        retryInterceptor = "jta".equals(type) ? new JtaRetryInterceptor() : new RetryInterceptor();
        if (element.hasAttribute("retries")) {
            String retriesText = element.getAttribute("retries");
            try {
                int retries = Integer.parseInt(retriesText);
                retryInterceptor.setRetries(retries);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse retries " + retriesText, element);
            }
        }
        if (element.hasAttribute("delay")) {
            String delayText = element.getAttribute("delay");
            try {
                long delay = Long.parseLong(delayText);
                retryInterceptor.setDelay(delay);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay " + delayText, element);
            }
        }
        if (element.hasAttribute("delay-factor")) {
            String delayFactorText = element.getAttribute("delay-factor");
            try {
                long delayFactor = Long.parseLong(delayFactorText);
                retryInterceptor.setDelayFactor(delayFactor);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay-factor " + delayFactorText, element);
            }
        }
        return new ProvidedObjectDescriptor(retryInterceptor);
    }
}

