/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.sequenceflow;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ConditionalSequenceflowTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/sequenceflow/conditional_sequence_flow.bpmn.xml");
        this.registerDeployment(deployment.deploy());
    }

    public void testBothSequenceflowTaken() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("var", 250);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("conditionalSequenceFlow", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).orderAsc("name");
        Task task = taskQuery.uniqueResult();
        ConditionalSequenceflowTest.assertEquals((String)"First task", (String)task.getName());
        this.taskService.completeTask(task.getId());
        List tasks = taskQuery.list();
        ConditionalSequenceflowTest.assertEquals((int)2, (int)tasks.size());
        ConditionalSequenceflowTest.assertEquals((String)"Second task", (String)((Task)tasks.get(0)).getName());
        ConditionalSequenceflowTest.assertEquals((String)"Third task", (String)((Task)tasks.get(1)).getName());
    }

    public void testOnlyOneSequenceFlow() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("var", 25);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("conditionalSequenceFlow", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Task task = taskQuery.uniqueResult();
        ConditionalSequenceflowTest.assertEquals((String)"First task", (String)task.getName());
        this.taskService.completeTask(task.getId());
        task = taskQuery.uniqueResult();
        ConditionalSequenceflowTest.assertEquals((String)"Second task", (String)task.getName());
    }

    public void testDefaultSequenceFlow() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("var", 2);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("conditionalSequenceFlow", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Task task = taskQuery.uniqueResult();
        ConditionalSequenceflowTest.assertEquals((String)"First task", (String)task.getName());
        this.taskService.completeTask(task.getId());
        task = taskQuery.uniqueResult();
        ConditionalSequenceflowTest.assertNotNull((Object)task);
        ConditionalSequenceflowTest.assertEquals((String)"Fourth task", (String)task.getName());
    }
}

