/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.subprocess.outcomeobject;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class SubProcessOutcomeObjectTest
extends JbpmTestCase {
    String subProcessReviewDeploymentId;
    String subProcessDocumentDeploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.subProcessReviewDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/outcomeobject/SubProcessReview.jpdl.xml").deploy();
        this.subProcessDocumentDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/outcomeobject/SubProcessDocument.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.subProcessReviewDeploymentId);
        this.repositoryService.deleteDeploymentCascade(this.subProcessDocumentDeploymentId);
        super.tearDown();
    }

    public void testSubProcessResultOk() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeObjectTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("result", 100);
        this.taskService.setVariables(task.getId(), variables);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeObjectTest.assertNotNull((Object)processInstance.findActiveExecutionIn("next step"));
    }

    public void testSubProcessResultNok() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeObjectTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("result", 200);
        this.taskService.setVariables(task.getId(), variables);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeObjectTest.assertNotNull((Object)processInstance.findActiveExecutionIn("update"));
    }

    public void testSubProcessResultReject() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeObjectTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("result", 300);
        this.taskService.setVariables(task.getId(), variables);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeObjectTest.assertNotNull((Object)processInstance.findActiveExecutionIn("close"));
    }
}

