/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.task.notification;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jbpm.examples.task.assignee.Order;
import org.jbpm.test.JbpmTestCase;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class TaskNotificationTest
extends JbpmTestCase {
    Wiser wiser = new Wiser();

    protected void setUp() throws Exception {
        super.setUp();
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/task/notification/process.jpdl.xml").deploy();
        this.registerDeployment(deploymentId);
        this.identityService.createUser("johndoe", "John", "Doe", "john@doe");
        this.wiser.setPort(2525);
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        this.wiser.stop();
        this.identityService.deleteUser("johndoe");
        super.tearDown();
    }

    public void testTaskNotification() throws MessagingException, IOException {
        Map<String, Order> variables = Collections.singletonMap("order", new Order("johndoe"));
        this.executionService.startProcessInstanceByKey("TaskNotification", variables);
        List wiserMessages = this.wiser.getMessages();
        TaskNotificationTest.assertEquals((int)1, (int)wiserMessages.size());
        WiserMessage wiserMessage = (WiserMessage)wiserMessages.get(0);
        MimeMessage message = wiserMessage.getMimeMessage();
        Address[] from = message.getFrom();
        TaskNotificationTest.assertEquals((int)1, (int)from.length);
        TaskNotificationTest.assertEquals((String)"noreply@jbpm.org", (String)from[0].toString());
        Object[] expectedTo = InternetAddress.parse((String)"john@doe");
        Object[] to = message.getRecipients(Message.RecipientType.TO);
        assert (Arrays.equals(expectedTo, to)) : Arrays.asList(to);
        TaskNotificationTest.assertEquals((String)"review", (String)message.getSubject());
        this.assertTextPresent("Task \"review\" has been assigned to you.", (String)message.getContent());
    }
}

