/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.task.reminder;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.api.task.Task;
import org.jbpm.examples.task.assignee.Order;
import org.jbpm.test.JbpmTestCase;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class TaskReminderTest
extends JbpmTestCase {
    Wiser wiser = new Wiser();

    protected void setUp() throws Exception {
        super.setUp();
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/task/reminder/process.jpdl.xml").deploy();
        this.registerDeployment(deploymentId);
        this.identityService.createUser("johndoe", "John", "Doe", "john@doe");
        this.wiser.setPort(2525);
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        this.wiser.stop();
        this.identityService.deleteUser("johndoe");
        super.tearDown();
    }

    public void testTaskReminder() throws MessagingException, IOException {
        Map<String, Order> variables = Collections.singletonMap("order", new Order("johndoe"));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TaskReminder", variables);
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        TaskReminderTest.assertNotNull((String)"expected job to be non-null", (Object)job);
        TaskReminderTest.assertEquals((int)0, (int)this.wiser.getMessages().size());
        this.managementService.executeJob(job.getId());
        List wiserMessages = this.wiser.getMessages();
        TaskReminderTest.assertEquals((int)1, (int)wiserMessages.size());
        WiserMessage wiserMessage = (WiserMessage)wiserMessages.get(0);
        MimeMessage message = wiserMessage.getMimeMessage();
        Address[] from = message.getFrom();
        TaskReminderTest.assertEquals((int)1, (int)from.length);
        TaskReminderTest.assertEquals((String)"noreply@jbpm.org", (String)from[0].toString());
        Object[] expectedTo = InternetAddress.parse((String)"john@doe");
        Object[] to = message.getRecipients(Message.RecipientType.TO);
        assert (Arrays.equals(expectedTo, to)) : Arrays.asList(to);
        TaskReminderTest.assertEquals((String)"review", (String)message.getSubject());
        TaskReminderTest.assertTrue((boolean)((String)message.getContent()).contains("Do not forget about task \"review\""));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        TaskReminderTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        TaskReminderTest.assertEquals((String)"review", (String)task.getName());
        TaskReminderTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        this.taskService.completeTask(task.getId());
        job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        TaskReminderTest.assertNull((String)"expected timer to be null", (Object)job);
    }
}

