/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.usertask.taskform;

import java.util.HashMap;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.history.HistoryActivityInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskFormTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/task/usertask/taskform/vacationrequest.bpmn.xml");
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/task/usertask/taskform/request_vacation.ftl");
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/task/usertask/taskform/verify_request.ftl");
        String deployId = deployment.deploy();
        this.registerDeployment(deployId);
        this.identityService.createUser("peter", "Peter", "Pan");
        this.identityService.createGroup("user");
        this.identityService.createMembership("peter", "user");
        this.identityService.createUser("alex", "Alex", "Ander");
        this.identityService.createGroup("manager");
        this.identityService.createMembership("alex", "manager");
    }

    protected void tearDown() throws Exception {
        this.identityService.deleteUser("peter");
        this.identityService.deleteGroup("user");
        this.identityService.deleteUser("alex");
        this.identityService.deleteGroup("manager");
        super.tearDown();
    }

    public void testRequestAccepted() {
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("vacationRequestProcess");
        Task requestTasktask = this.taskService.createTaskQuery().candidate("peter").uniqueResult();
        TaskFormTest.assertNotNull((Object)requestTasktask);
        TaskFormTest.assertEquals((String)"org/jbpm/examples/bpmn/task/usertask/taskform/request_vacation.ftl", (String)requestTasktask.getFormResourceName());
        TaskQuery verifyTaskQuery = this.taskService.createTaskQuery().candidate("alex");
        TaskFormTest.assertNull((Object)verifyTaskQuery.uniqueResult());
        this.taskService.completeTask(requestTasktask.getId());
        Task verifyTask = verifyTaskQuery.uniqueResult();
        TaskFormTest.assertEquals((String)"org/jbpm/examples/bpmn/task/usertask/taskform/verify_request.ftl", (String)verifyTask.getFormResourceName());
        TaskFormTest.assertNotNull((Object)verifyTask);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("verificationResult", "OK");
        this.taskService.completeTask(verifyTask.getId(), vars);
        this.assertProcessInstanceEnded(pi);
    }

    public void testRequestRefused() {
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("vacationRequestProcess");
        Task requestTasktask = this.taskService.createTaskQuery().candidate("peter").uniqueResult();
        this.taskService.completeTask(requestTasktask.getId());
        Task verifyTask = this.taskService.createTaskQuery().candidate("alex").uniqueResult();
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("verificationResult", "Not OK");
        this.taskService.completeTask(verifyTask.getId(), vars);
        this.assertProcessInstanceEnded(pi);
        HistoryActivityInstance hai = this.historyService.createHistoryActivityInstanceQuery().activityName("sendRejectionMessage").uniqueResult();
        TaskFormTest.assertNotNull((Object)hai);
    }
}

