/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.task.variables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskVariablesTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/task/variables/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testTaskAssignee() {
        Map<String, Integer> variables = new HashMap<String, Object>();
        variables.put("category", (Integer)((Object)"big"));
        variables.put("dollars", 100000);
        ProcessInstance execution = this.executionService.startProcessInstanceByKey("TaskVariables", variables);
        List taskList = this.taskService.findPersonalTasks("johndoe");
        TaskVariablesTest.assertFalse((String)"Task list for assignee was empty", (boolean)taskList.isEmpty());
        Task task = (Task)taskList.get(0);
        String taskId = task.getId();
        Set variableNames = this.taskService.getVariableNames(taskId);
        HashSet<String> expectedVariableNames = new HashSet<String>();
        expectedVariableNames.add("category");
        expectedVariableNames.add("dollars");
        TaskVariablesTest.assertEquals(expectedVariableNames, (Object)variableNames);
        HashMap<String, Object> expectedVariables = variables;
        variables = this.taskService.getVariables(taskId, variableNames);
        TaskVariablesTest.assertEquals(expectedVariables, variables);
        variables = new HashMap();
        variables.put("category", (Integer)((Object)"small"));
        variables.put("lires", 923874893);
        this.taskService.setVariables(taskId, variables);
        expectedVariables = new HashMap();
        expectedVariables.put("category", "small");
        expectedVariables.put("lires", 923874893);
        expectedVariables.put("dollars", 100000);
        HashSet names = new HashSet(expectedVariables.keySet());
        variables = this.executionService.getVariables(execution.getId(), names);
        TaskVariablesTest.assertEquals(expectedVariables, variables);
    }
}

