/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.builder;

import java.lang.reflect.Constructor;
import org.jbpm.pvm.internal.builder.ActivityBehaviourBuilder;
import org.jbpm.pvm.internal.builder.CompositeBuilder;
import org.jbpm.pvm.internal.builder.FlowBuilder;
import org.jbpm.pvm.internal.builder.UnresolvedFlow;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Continuation;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityBuilder
extends CompositeBuilder {
    private static final Class<?>[] ACTIVITYBEHAVIOURBUILDER_PARAMTYPES = new Class[]{ActivityBuilder.class};
    protected CompositeBuilder compositeBuilder;
    protected ActivityImpl activity;

    public ActivityBuilder(CompositeBuilder compositeBuilder, String activityName) {
        this.compositeBuilder = compositeBuilder;
        this.activity = compositeBuilder.createActivity();
        this.compositeElement = this.activity;
        this.activity.setName(activityName);
    }

    public ActivityBuilder initial() {
        this.setProcessDefinitionInitial(this.activity);
        return this;
    }

    @Override
    protected void setProcessDefinitionInitial(ActivityImpl initial) {
        this.compositeBuilder.setProcessDefinitionInitial(initial);
    }

    public <T extends ActivityBehaviourBuilder> T startBehaviour(Class<T> activityBehaviourBuilderType) {
        return this.startBehaviour(null, activityBehaviourBuilderType);
    }

    public <T extends ActivityBehaviourBuilder> T startBehaviour(String activityName, Class<T> activityBehaviourBuilderType) {
        if (activityBehaviourBuilderType == null) {
            throw new RuntimeException("activityBuilderType is null");
        }
        try {
            Constructor<T> constructor = activityBehaviourBuilderType.getConstructor(ACTIVITYBEHAVIOURBUILDER_PARAMTYPES);
            ActivityBehaviourBuilder activityBuilder = (ActivityBehaviourBuilder)constructor.newInstance(this);
            return (T)activityBuilder;
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't instantiate activity behaviour builder type " + activityBehaviourBuilderType.getName(), e);
        }
    }

    @Override
    public CompositeBuilder endActivity() {
        return this.compositeBuilder;
    }

    @Override
    public FlowBuilder startFlow(String to) {
        UnresolvedFlow unresolvedFlow = new UnresolvedFlow();
        unresolvedFlow.transition = this.activity.createOutgoingTransition();
        unresolvedFlow.destinationName = to;
        this.addUnresolvedFlow(unresolvedFlow);
        return new FlowBuilder(this, unresolvedFlow.transition);
    }

    @Override
    public ProcessDefinitionImpl endProcess() {
        return this.compositeBuilder.endProcess();
    }

    public ActivityBuilder transition(String to) {
        this.startFlow(to);
        return this;
    }

    public ActivityBuilder transition(String to, String name) {
        this.startFlow(to).name(name);
        return this;
    }

    public ActivityBuilder asyncExecute() {
        this.activity.setContinuation(Continuation.ASYNCHRONOUS);
        return this;
    }

    @Override
    protected void addUnresolvedFlow(UnresolvedFlow unresolvedFlow) {
        this.compositeBuilder.addUnresolvedFlow(unresolvedFlow);
    }
}

