/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.client.ClientExecution;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.model.HistoryCommentImpl;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.id.DbidGenerator;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.job.StartProcessTimer;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.query.DeploymentQueryImpl;
import org.jbpm.pvm.internal.query.HistoryActivityInstanceQueryImpl;
import org.jbpm.pvm.internal.query.HistoryDetailQueryImpl;
import org.jbpm.pvm.internal.query.HistoryProcessInstanceQueryImpl;
import org.jbpm.pvm.internal.query.JobQueryImpl;
import org.jbpm.pvm.internal.query.ProcessInstanceQueryImpl;
import org.jbpm.pvm.internal.query.TaskQueryImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSessionImpl
implements DbSession {
    private static Log log = Log.getLog(DbSessionImpl.class.getName());
    protected Session session;

    public void close() {
        this.session.close();
    }

    @Override
    public <T> T get(Class<T> entityClass, Object primaryKey) {
        return entityClass.cast(this.session.get(entityClass, (Serializable)primaryKey));
    }

    @Override
    public void flush() {
        this.session.flush();
    }

    public void forceVersionUpdate(Object entity) {
        this.session.lock(entity, LockMode.FORCE);
    }

    public void lockPessimistically(Object entity) {
        this.session.lock(entity, LockMode.UPGRADE);
    }

    @Override
    public void save(Object entity) {
        this.session.save(entity);
    }

    @Override
    public void update(Object entity) {
        this.session.update(entity);
    }

    public void merge(Object entity) {
        this.session.merge(entity);
    }

    @Override
    public void delete(Object entity) {
        this.session.delete(entity);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void deleteProcessDefinitionHistory(String processDefinitionId) {
        List historyProcessInstances = this.session.createCriteria(HistoryProcessInstanceImpl.class).add((Criterion)Restrictions.eq((String)"processDefinitionId", (Object)processDefinitionId)).list();
        for (Object hpi : historyProcessInstances) {
            this.session.delete(hpi);
        }
    }

    public boolean isHistoryEnabled() {
        ClassMetadata historyHibernateMetadata = this.session.getSessionFactory().getClassMetadata(HistoryProcessInstanceImpl.class);
        return historyHibernateMetadata != null;
    }

    @Override
    public ClientExecution findExecutionById(String executionId) {
        return (ClientExecution)this.session.getNamedQuery("findExecutionById").setString("id", executionId).setMaxResults(1).uniqueResult();
    }

    @Override
    public ClientExecution findProcessInstanceById(String processInstanceId) {
        return (ClientExecution)this.session.getNamedQuery("findProcessInstanceById").setString("processInstanceId", processInstanceId).setMaxResults(1).uniqueResult();
    }

    public ClientExecution findProcessInstanceByIdIgnoreSuspended(String processInstanceId) {
        return (ClientExecution)this.session.getNamedQuery("findProcessInstanceByIdIgnoreSuspended").setString("processInstanceId", processInstanceId).setMaxResults(1).uniqueResult();
    }

    @Override
    public List<String> findProcessInstanceIds(String processDefinitionId) {
        List processInstanceIds = this.session.getNamedQuery("findProcessInstanceIds").setString("processDefinitionId", processDefinitionId).list();
        return CollectionUtil.checkList(processInstanceIds, String.class);
    }

    public void deleteProcessInstance(String processInstanceId) {
        this.deleteProcessInstance(processInstanceId, true);
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, boolean deleteHistory) {
        ExecutionImpl processInstance;
        HistoryProcessInstanceImpl historyProcessInstance;
        if (processInstanceId == null) {
            throw new JbpmException("processInstanceId is null");
        }
        if (deleteHistory && this.isHistoryEnabled() && (historyProcessInstance = this.findHistoryProcessInstanceById(processInstanceId)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("deleting history process instance " + processInstanceId);
            }
            this.session.delete((Object)historyProcessInstance);
        }
        if ((processInstance = (ExecutionImpl)this.findProcessInstanceByIdIgnoreSuspended(processInstanceId)) != null) {
            this.deleteSubProcesses(processInstance, deleteHistory);
            List<TaskImpl> tasks = this.findTasks(processInstanceId);
            for (TaskImpl task : tasks) {
                this.session.delete((Object)task);
            }
            JobImpl currentJob = EnvironmentImpl.getFromCurrent(JobImpl.class, false);
            List<JobImpl> jobs = this.findJobs(processInstanceId);
            for (JobImpl job : jobs) {
                if (job == currentJob) continue;
                this.session.delete((Object)job);
            }
            if (log.isDebugEnabled()) {
                log.debug("Deleting process instance " + processInstanceId);
            }
        } else {
            throw new JbpmException("Can't delete processInstance " + processInstanceId + ": no processInstance found for the given id");
        }
        this.session.delete((Object)processInstance);
    }

    private void deleteSubProcesses(ExecutionImpl execution, boolean deleteHistory) {
        Collection<ExecutionImpl> childExecutions;
        ExecutionImpl subProcessInstance = execution.getSubProcessInstance();
        if (subProcessInstance != null) {
            subProcessInstance.setSuperProcessExecution(null);
            execution.setSubProcessInstance(null);
            this.deleteProcessInstance(subProcessInstance.getId(), deleteHistory);
        }
        if ((childExecutions = execution.getExecutions()) != null) {
            for (ExecutionImpl childExecution : childExecutions) {
                this.deleteSubProcesses(childExecution, deleteHistory);
            }
        }
    }

    public HistoryProcessInstanceImpl findHistoryProcessInstanceById(String processInstanceId) {
        return (HistoryProcessInstanceImpl)this.session.createCriteria(HistoryProcessInstanceImpl.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)processInstanceId)).uniqueResult();
    }

    List<TaskImpl> findTasks(String processInstanceId) {
        List tasks = this.session.createCriteria(TaskImpl.class).createAlias("processInstance", "pi").add((Criterion)Restrictions.eq((String)"pi.id", (Object)processInstanceId)).list();
        return CollectionUtil.checkList(tasks, TaskImpl.class);
    }

    List<JobImpl> findJobs(String processInstanceId) {
        List jobs = this.session.createCriteria(JobImpl.class).createAlias("processInstance", "pi").add((Criterion)Restrictions.eq((String)"pi.id", (Object)processInstanceId)).list();
        return CollectionUtil.checkList(jobs, JobImpl.class);
    }

    @Override
    public void cascadeExecutionSuspend(ExecutionImpl execution) {
        List jobs = this.session.createCriteria(JobImpl.class).add((Criterion)Restrictions.eq((String)"execution", (Object)execution)).add((Criterion)Restrictions.ne((String)"state", (Object)"suspended")).list();
        for (JobImpl job : CollectionUtil.checkList(jobs, JobImpl.class)) {
            job.suspend();
        }
        List tasks = this.session.createCriteria(TaskImpl.class).add((Criterion)Restrictions.eq((String)"execution", (Object)execution)).add((Criterion)Restrictions.ne((String)"state", (Object)"suspended")).list();
        for (TaskImpl task : CollectionUtil.checkList(tasks, TaskImpl.class)) {
            task.suspend();
        }
    }

    @Override
    public void cascadeExecutionResume(ExecutionImpl execution) {
        List jobs = this.session.createCriteria(JobImpl.class).add((Criterion)Restrictions.eq((String)"execution", (Object)execution)).add((Criterion)Restrictions.eq((String)"state", (Object)"suspended")).list();
        for (JobImpl job : CollectionUtil.checkList(jobs, JobImpl.class)) {
            job.resume();
        }
        List tasks = this.session.createCriteria(TaskImpl.class).add((Criterion)Restrictions.eq((String)"execution", (Object)execution)).add((Criterion)Restrictions.eq((String)"state", (Object)"suspended")).list();
        for (TaskImpl task : CollectionUtil.checkList(tasks, TaskImpl.class)) {
            task.resume();
        }
    }

    @Override
    public TaskImpl createTask() {
        TaskImpl task = this.newTask();
        task.setCreateTime(Clock.getTime());
        return task;
    }

    protected TaskImpl newTask() {
        TaskImpl task = new TaskImpl();
        long dbid = EnvironmentImpl.getFromCurrent(DbidGenerator.class).getNextId();
        task.setDbid(dbid);
        task.setNew(true);
        return task;
    }

    public TaskImpl findTaskByDbid(long taskDbid) {
        return (TaskImpl)this.session.get(TaskImpl.class, (Serializable)Long.valueOf(taskDbid));
    }

    @Override
    public TaskImpl findTaskByExecution(Execution execution) {
        return (TaskImpl)this.session.createCriteria(TaskImpl.class).add((Criterion)Restrictions.eq((String)"execution", (Object)execution)).uniqueResult();
    }

    @Override
    public JobImpl findFirstAcquirableJob() {
        return (JobImpl)this.session.getNamedQuery("findFirstAcquirableJob").setTimestamp("now", Clock.getTime()).setMaxResults(1).uniqueResult();
    }

    @Override
    public List<JobImpl> findExclusiveJobs(Execution processInstance) {
        List exclusiveJobs = this.session.getNamedQuery("findExclusiveJobs").setTimestamp("now", Clock.getTime()).setEntity("processInstance", (Object)processInstance).list();
        return CollectionUtil.checkList(exclusiveJobs, JobImpl.class);
    }

    @Override
    public JobImpl findFirstDueJob() {
        return (JobImpl)this.session.getNamedQuery("findFirstDueJob").setMaxResults(1).uniqueResult();
    }

    @Override
    public List<StartProcessTimer> findStartProcessTimers(String processDefinitionName) {
        List timers = this.session.createCriteria(StartProcessTimer.class).add((Criterion)Restrictions.eq((String)"signalName", (Object)processDefinitionName)).list();
        return CollectionUtil.checkList(timers, StartProcessTimer.class);
    }

    @Override
    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    @Override
    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    @Override
    public HistoryProcessInstanceQueryImpl createHistoryProcessInstanceQuery() {
        return new HistoryProcessInstanceQueryImpl();
    }

    @Override
    public HistoryActivityInstanceQueryImpl createHistoryActivityInstanceQuery() {
        return new HistoryActivityInstanceQueryImpl();
    }

    @Override
    public HistoryDetailQueryImpl createHistoryDetailQuery() {
        return new HistoryDetailQueryImpl();
    }

    @Override
    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    @Override
    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    @Override
    public List<HistoryComment> findCommentsByTaskId(String taskId) {
        List comments = this.session.createCriteria(HistoryCommentImpl.class).createAlias("historyTask", "task").add((Criterion)Restrictions.eq((String)"task.dbid", (Object)Long.parseLong(taskId))).addOrder(Order.asc((String)"historyTaskIndex")).list();
        return CollectionUtil.checkList(comments, HistoryComment.class);
    }
}

