/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.assertion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAssertions {
    private CollectionAssertions() {
    }

    public static <T> void assertContainsSameElements(Collection<T> collection1, Collection<T> collection2) {
        Assert.assertTrue((String)"One of the given collections is null, while the other collection is not null", (collection1 == null && collection2 == null || collection1 != null && collection2 != null ? 1 : 0) != 0);
        if (collection1 != null && collection2 != null) {
            Assert.assertEquals((String)("Collection 1 does not have the same number of elements as collection 2. " + CollectionAssertions.debugCollections(collection1, collection2)), (int)collection1.size(), (int)collection2.size());
            for (T t : collection1) {
                Assert.assertTrue((String)("Collection 1 contains element" + t + ", which does not exist in collection 2 "), (boolean)collection2.contains(t));
            }
        }
    }

    public static <T> void assertContainsSameElements(Collection<T> collection1, T ... elements) {
        CollectionAssertions.assertContainsSameElements(collection1, Arrays.asList(elements));
    }

    private static String debugCollections(Collection ... collections) {
        StringBuilder strb = new StringBuilder();
        for (int i = 0; i < collections.length; ++i) {
            strb.append("Collection " + (i + 1) + ": " + CollectionAssertions.debugCollection(collections[i]) + ". ");
        }
        return strb.toString();
    }

    private static String debugCollection(Collection collection) {
        StringBuilder strb = new StringBuilder();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            strb.append("'" + it.next() + "', ");
        }
        if (strb.length() > 2) {
            strb.delete(strb.length() - 2, strb.length());
        }
        return strb.toString();
    }
}

