/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.Map;
import org.jbpm.api.Execution;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.task.Assignable;
import org.jbpm.api.task.Task;
import org.jbpm.bpmn.flownodes.BpmnExternalActivity;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskActivityStart;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ObservableElement;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.AssignableDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTaskActivity
extends BpmnExternalActivity {
    private static final long serialVersionUID = 1L;
    protected TaskDefinitionImpl taskDefinition;

    @Override
    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    @Override
    public void execute(ExecutionImpl execution) {
        DbSession dbSession = (DbSession)EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = dbSession.createTask();
        task.setTaskDefinition(this.taskDefinition);
        task.setExecution(execution);
        task.setProcessInstance(execution.getProcessInstance());
        task.setSignalling(true);
        Expression assigneeExpression = this.taskDefinition.getAssigneeExpression();
        if (assigneeExpression != null) {
            Object assignee = assigneeExpression.evaluate((Execution)execution);
            task.setAssignee(assignee != null ? assignee.toString() : null);
        }
        if (this.taskDefinition.getName() != null) {
            task.setName(this.taskDefinition.getName());
        } else {
            task.setName(execution.getActivityName());
        }
        Expression descriptionExpression = this.taskDefinition.getDescription();
        if (descriptionExpression != null) {
            String description = (String)descriptionExpression.evaluate((Task)task);
            task.setDescription(description);
        }
        task.setPriority(this.taskDefinition.getPriority());
        task.setFormResourceName(this.taskDefinition.getFormResourceName());
        dbSession.save((Object)task);
        execution.initializeAssignments((AssignableDefinitionImpl)this.taskDefinition, (Assignable)task);
        HistoryEvent.fire((HistoryEvent)new TaskActivityStart(task), (ExecutionImpl)execution);
        execution.waitForSignal();
    }

    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        this.signal((ExecutionImpl)execution, signalName, parameters);
    }

    public void signal(ExecutionImpl execution, String signalName, Map<String, ?> parameters) throws Exception {
        ActivityImpl activity = execution.getActivity();
        if (parameters != null) {
            execution.setVariables(parameters);
        }
        execution.fire(signalName, (ObservableElement)activity);
        DbSession taskDbSession = (DbSession)EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = taskDbSession.findTaskByExecution((Execution)execution);
        if (task != null) {
            task.setSignalling(false);
        }
        execution.setVariable("jbpm_outcome", (Object)signalName);
        this.proceed(execution, this.findOutgoingSequenceFlow(execution, true));
    }

    public TaskDefinitionImpl getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(TaskDefinitionImpl taskDefinition) {
        this.taskDefinition = taskDefinition;
    }
}

