/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.parser;

import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.xml.namespace.QName;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.model.Transition;
import org.jbpm.bpmn.common.Resource;
import org.jbpm.bpmn.common.ResourceParameter;
import org.jbpm.bpmn.flownodes.BpmnActivity;
import org.jbpm.bpmn.model.BpmnProcessDefinition;
import org.jbpm.bpmn.model.SequenceflowCondition;
import org.jbpm.bpmn.parser.BindingsParser;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cal.CronExpression;
import org.jbpm.pvm.internal.cal.Duration;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ScopeElementImpl;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.VariableDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.util.CollectionUtil;
import org.jbpm.pvm.internal.util.TagBinding;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Binding;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnParser
extends Parser {
    private static final Log log = Log.getLog((String)BpmnParser.class.getName());
    private static final String[] DEFAULT_ACTIVITIES_RESOURCES = new String[]{"jbpm.bpmn.flownodes.xml"};
    private static final String CATEGORY_ACTIVITY = "activity";
    private static final String[] SCHEMA_RESOURCES = new String[]{"BPMN20.xsd", "DiagramDefinition.xsd", "DiagramInterchange.xsd", "BpmnDi.xsd"};
    static BindingsParser bindingsParser = new BindingsParser();

    public BpmnParser() {
        this.parseBindings();
        this.setSchemaResources(SCHEMA_RESOURCES);
    }

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        ArrayList<ProcessDefinitionImpl> processDefinitions = new ArrayList<ProcessDefinitionImpl>();
        this.parseDefinition(documentElement, parse);
        for (Element processElement : XmlUtil.elements((Element)documentElement, (String)"process")) {
            ProcessDefinitionImpl processDefinition = this.parseProcess(processElement, parse);
            processDefinitions.add(processDefinition);
        }
        return processDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinitionImpl parseProcess(Element processElement, Parse parse) {
        BpmnProcessDefinition processDefinition = new BpmnProcessDefinition();
        parse.contextStackPush((Object)processDefinition);
        try {
            Element descriptionElement;
            String id = XmlUtil.attribute((Element)processElement, (String)"id", (Parse)parse);
            String name = XmlUtil.attribute((Element)processElement, (String)"name");
            if (id != null && !"".equals(id)) {
                processDefinition.setName(id);
            } else {
                parse.addProblem("Process has no or an empty id");
            }
            if (name != null) {
                processDefinition.setKey(name);
            }
            if ((descriptionElement = XmlUtil.element((Element)processElement, (String)"documentation")) != null) {
                String description = XmlUtil.getContentText((Element)descriptionElement);
                processDefinition.setDescription(description);
            }
            this.parseResources((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseInterfaces((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseItemDefinitions((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseMessages((Element)processElement.getParentNode(), parse, processDefinition);
            this.parseDataObjects(processElement, parse, processDefinition);
            this.parseActivities(processElement, parse, (CompositeElementImpl)processDefinition);
            this.parseSequenceFlow(processElement, parse, processDefinition);
        }
        finally {
            parse.contextStackPop();
        }
        return processDefinition;
    }

    protected void parseBindings() {
        Bindings bindings = new Bindings();
        this.setBindings(bindings);
        for (String activityResource : DEFAULT_ACTIVITIES_RESOURCES) {
            Enumeration<URL> resourceUrls = this.getResources(activityResource);
            if (resourceUrls.hasMoreElements()) {
                while (resourceUrls.hasMoreElements()) {
                    URL resourceUrl = resourceUrls.nextElement();
                    log.trace("loading bpmn activities from resource: " + resourceUrl);
                    List activityBindings = (List)bindingsParser.createParse().setUrl(resourceUrl).execute().checkErrors("bpmn activities from " + resourceUrl.toString()).getDocumentObject();
                    for (TagBinding binding : CollectionUtil.checkList((List)activityBindings, TagBinding.class)) {
                        binding.setCategory(CATEGORY_ACTIVITY);
                        bindings.addBinding((Binding)binding);
                    }
                }
                continue;
            }
            log.trace("skipping unavailable activities resource: " + activityResource);
        }
    }

    protected Enumeration<URL> getResources(String resourceName) {
        Enumeration<URL> resourceUrls;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            resourceUrls = classLoader.getResources(resourceName);
            if (!resourceUrls.hasMoreElements()) {
                resourceUrls = BpmnParser.class.getClassLoader().getResources(resourceName);
            }
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get resource urls for " + resourceName, (Throwable)e);
        }
        return resourceUrls;
    }

    private void parseDataObjects(Element element, Parse parse, BpmnProcessDefinition processDefinition) {
        ArrayList<VariableDefinitionImpl> variableDefinitions = new ArrayList<VariableDefinitionImpl>();
        for (Element dataElement : XmlUtil.elements((Element)element, (String)"dataObject")) {
            VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl();
            String name = XmlUtil.attribute((Element)dataElement, (String)"id", (Parse)parse);
            variableDefinition.setName(name);
            String typeRef = XmlUtil.attribute((Element)dataElement, (String)"itemSubjectRef");
            variableDefinition.setTypeName(processDefinition.getType(typeRef));
            variableDefinitions.add(variableDefinition);
        }
        processDefinition.setVariableDefinition(variableDefinitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseActivities(Element element, Parse parse, CompositeElementImpl compositeElement) {
        List elements = XmlUtil.elements((Element)element);
        for (Element nestedElement : elements) {
            String tagName = nestedElement.getLocalName();
            String name = XmlUtil.attribute((Element)nestedElement, (String)"name");
            String id = XmlUtil.attribute((Element)nestedElement, (String)"id", (Parse)parse);
            TagBinding activityBinding = (TagBinding)this.getBinding(nestedElement, CATEGORY_ACTIVITY);
            if (activityBinding == null) {
                if ("sequenceFlow".equals(tagName)) continue;
                log.debug("unrecognized activity: " + tagName);
                continue;
            }
            ActivityImpl activity = compositeElement.createActivity();
            parse.contextStackPush((Object)activity);
            try {
                activity.setType(activityBinding.getTagName());
                activity.setName(id);
                activity.setDescription(name);
                if (log.isDebugEnabled()) {
                    log.debug("Parsing Activity: " + name + "(id=" + id + ")");
                }
                ActivityBehaviour activityBehaviour = (ActivityBehaviour)activityBinding.parse(nestedElement, parse, (Parser)this);
                activity.setActivityBehaviour(activityBehaviour);
            }
            finally {
                parse.contextStackPop();
            }
        }
    }

    public void parseSequenceFlow(Element element, Parse parse, BpmnProcessDefinition processDefinition) {
        List transitionElements = XmlUtil.elements((Element)element, (String)"sequenceFlow");
        for (Element transitionElement : transitionElements) {
            TransitionImpl transition;
            String transitionId;
            block13: {
                String transitionName = XmlUtil.attribute((Element)transitionElement, (String)"name");
                transitionId = XmlUtil.attribute((Element)transitionElement, (String)"id", (Parse)parse);
                String sourceRef = XmlUtil.attribute((Element)transitionElement, (String)"sourceRef", (Parse)parse);
                String targetRef = XmlUtil.attribute((Element)transitionElement, (String)"targetRef", (Parse)parse);
                if (log.isDebugEnabled()) {
                    log.debug(transitionId + ": " + sourceRef + " -> " + targetRef);
                }
                ActivityImpl sourceActivity = processDefinition.findActivity(sourceRef);
                transition = null;
                if (sourceActivity != null) {
                    transition = sourceActivity.createOutgoingTransition();
                    transition.setName(transitionId);
                    transition.setDescription(transitionName);
                } else {
                    parse.addProblem("SourceRef " + sourceRef + " cannot be found");
                }
                ActivityImpl destinationActivity = processDefinition.findActivity(targetRef);
                if (destinationActivity != null) {
                    destinationActivity.addIncomingTransition(transition);
                } else {
                    parse.addProblem("TargetRef '" + targetRef + "' cannot be found");
                }
                try {
                    ActivityBehaviour behaviour = sourceActivity.getActivityBehaviour();
                    if (behaviour instanceof BpmnActivity) {
                        BpmnActivity bpmnActivity = (BpmnActivity)behaviour;
                        String defaultSeqFlow = bpmnActivity.getDefault();
                        if (bpmnActivity.isDefaultEnabled() && defaultSeqFlow != null) {
                            if (transitionId.equals(defaultSeqFlow)) {
                                processDefinition.findActivity(sourceRef).setDefaultOutgoingTransition(transition);
                            }
                        } else {
                            processDefinition.findActivity(sourceRef).setDefaultOutgoingTransition(null);
                        }
                    } else {
                        processDefinition.findActivity(sourceRef).setDefaultOutgoingTransition(null);
                    }
                }
                catch (JbpmException je) {
                    if (je.getMessage().contains("no behaviour on")) break block13;
                    throw je;
                }
            }
            this.parseConditionOnSequenceFlow(parse, transitionElement, transitionId, transition);
            processDefinition.addSequenceFlow(transitionId, (Transition)transition);
        }
    }

    public void parseConditionOnSequenceFlow(Parse parse, Element transitionElement, String transitionId, TransitionImpl transition) {
        Element conditionElement = XmlUtil.element((Element)transitionElement, (String)"conditionExpression");
        if (conditionElement != null) {
            String type = conditionElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if ("bpmn:tFormalExpression".equals(type) || "tFormalExpression".equals(type)) {
                String expr = conditionElement.getTextContent();
                String lang = XmlUtil.attribute((Element)conditionElement, (String)"language");
                if (expr != null) {
                    expr = expr.trim();
                }
                SequenceflowCondition condition = new SequenceflowCondition();
                condition.setExpression(expr);
                condition.setLanguage(lang);
                transition.setCondition((Condition)condition);
            } else {
                parse.addProblem("Type of the conditionExpression on sequenceFlow with id=" + transitionId + " is of onsupported type 'bpmn:tExpression'", transitionElement);
            }
        }
    }

    public void parseDefinition(Element documentElement, Parse parse) {
        this.parseImports(documentElement, parse);
    }

    public TaskDefinitionImpl parseTaskDefinition(Element element, Parse parse, ScopeElementImpl scopeElement) {
        TaskDefinitionImpl taskDefinition = new TaskDefinitionImpl();
        String taskName = XmlUtil.attribute((Element)element, (String)"name");
        taskDefinition.setName(taskName);
        BpmnProcessDefinition processDefinition = (BpmnProcessDefinition)((Object)parse.contextStackFind(BpmnProcessDefinition.class));
        if (processDefinition.getTaskDefinition(taskName) != null) {
            parse.addProblem("duplicate task name " + taskName, element);
        } else {
            processDefinition.addTaskDefinitionImpl(taskDefinition);
        }
        return taskDefinition;
    }

    public TimerDefinitionImpl parseTimerEventDefinition(Element timerEventDefinitionElement, Parse parse, String eventId) {
        Element timeDate = XmlUtil.element((Element)timerEventDefinitionElement, (String)"timeDate");
        Element timeCycle = XmlUtil.element((Element)timerEventDefinitionElement, (String)"timeCycle");
        if (timeDate != null && timeCycle != null || timeDate == null && timeCycle == null) {
            parse.addProblem("timerEventDefinition for event '" + eventId + "' requires either a timeDate or a timeCycle definition (but not both)");
            return null;
        }
        TimerDefinitionImpl timerDefinition = new TimerDefinitionImpl();
        if (timeDate != null) {
            this.parseTimeDate(eventId, parse, timeDate, timerDefinition);
        }
        if (timeCycle != null) {
            this.parseTimeCycle(eventId, parse, timeCycle, timerDefinition);
        }
        return timerDefinition;
    }

    protected void parseTimeDate(String catchEventId, Parse parse, Element timeDate, TimerDefinitionImpl timerDefinition) {
        String dueDateTime = timeDate.getTextContent();
        String dueDateTimeFormatText = (String)EnvironmentImpl.getFromCurrent((String)"jbpm.duedatetime.format", (boolean)false);
        if (dueDateTimeFormatText == null) {
            dueDateTimeFormatText = "dd/MM/yyyy HH:mm:ss";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dueDateTimeFormatText);
        try {
            Date duedatetimeDate = dateFormat.parse(dueDateTime);
            timerDefinition.setDueDate(duedatetimeDate);
        }
        catch (ParseException e) {
            parse.addProblem("couldn't parse timeDate '" + dueDateTime + "' on intermediate catch timer event " + catchEventId, (Exception)e);
        }
    }

    protected void parseTimeCycle(String catchEventId, Parse parse, Element timeCycle, TimerDefinitionImpl timerDefinition) {
        String cycleExpression = timeCycle.getTextContent();
        if (Duration.isValidExpression((String)cycleExpression)) {
            timerDefinition.setDueDateDescription(cycleExpression);
        } else if (CronExpression.isValidExpression((String)cycleExpression)) {
            timerDefinition.setCronExpression(cycleExpression);
        } else {
            parse.addProblem("couldn't parse timeDate duration '" + cycleExpression + "' on intermediate catch timer event " + catchEventId);
        }
    }

    public void parseResources(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element resourceElement : XmlUtil.elements((Element)documentElement, (String)"resource")) {
            Resource resource = new Resource();
            resource.setId(XmlUtil.attribute((Element)resourceElement, (String)"id"));
            resource.setName(XmlUtil.attribute((Element)resourceElement, (String)"name"));
            for (Element resourceParameterElement : XmlUtil.elements((Element)documentElement, (String)"resourceParameter")) {
                ResourceParameter resourceParameter = new ResourceParameter();
                resourceParameter.setId(XmlUtil.attribute((Element)resourceParameterElement, (String)"id"));
                resourceParameter.setName(XmlUtil.attribute((Element)resourceParameterElement, (String)"name"));
                resourceParameter.setType(QName.valueOf(XmlUtil.attribute((Element)resourceParameterElement, (String)"name")));
                resource.getParameters().put(XmlUtil.attribute((Element)resourceParameterElement, (String)"name"), resourceParameter);
            }
            processDefinition.getResources().put(resource.getName(), resource);
        }
    }

    public void parseInterfaces(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element interfaceElement : XmlUtil.elements((Element)documentElement, (String)"interface")) {
            for (Element operationElement : XmlUtil.elements((Element)interfaceElement, (String)"operation")) {
                processDefinition.getOperations().put(XmlUtil.attribute((Element)operationElement, (String)"id"), operationElement);
            }
            processDefinition.getInterfaces().put(XmlUtil.attribute((Element)interfaceElement, (String)"id"), interfaceElement);
        }
    }

    public void parseMessages(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element messageElement : XmlUtil.elements((Element)documentElement, (String)"message")) {
            processDefinition.getMessages().put(XmlUtil.attribute((Element)messageElement, (String)"id"), messageElement);
        }
    }

    public void parseItemDefinitions(Element documentElement, Parse parse, BpmnProcessDefinition processDefinition) {
        for (Element itemDefinitionElement : XmlUtil.elements((Element)documentElement, (String)"itemDefinition")) {
            processDefinition.getItemDefinitions().put(XmlUtil.attribute((Element)itemDefinitionElement, (String)"id"), itemDefinitionElement);
        }
    }

    public void parseImports(Element documentElement, Parse parse) {
    }
}

