/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.usertask;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class UserTaskTest
extends JbpmTestCase {
    private static String[] PROCESS_LOCATIONS = new String[]{"org/jbpm/examples/bpmn/task/usertask/user_task_potential_owner_user.bpmn.xml", "org/jbpm/examples/bpmn/task/usertask/user_task_potential_owner_group.bpmn.xml", "org/jbpm/examples/bpmn/task/usertask/user_task_human_performer_user.bpmn.xml", "org/jbpm/examples/bpmn/task/usertask/user_task_human_performer_variable.bpmn.xml"};
    private static final String PETER = "peter";
    private static final String MARY = "mary";

    protected void setUp() throws Exception {
        super.setUp();
        for (String processLocation : PROCESS_LOCATIONS) {
            NewDeployment deployment = this.repositoryService.createDeployment();
            deployment.addResourceFromClasspath(processLocation);
            this.registerDeployment(deployment.deploy());
        }
        this.identityService.createGroup("management");
        this.identityService.createUser(PETER, "Peter", "Pan");
        this.identityService.createMembership(PETER, "management");
        this.identityService.createUser(MARY, "Mary", "Littlelamb");
        this.identityService.createMembership(MARY, "management");
    }

    protected void tearDown() throws Exception {
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser(PETER);
        this.identityService.deleteUser(MARY);
        super.tearDown();
    }

    public void testPotentialOwnerUser() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("userTaskPotentialOwnerUser");
        Task task = this.taskService.createTaskQuery().candidate(PETER).uniqueResult();
        UserTaskTest.assertEquals((String)"My User task", (String)task.getName());
        this.taskService.completeTask(task.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testPotentialOwnerGroup() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("userTaskPotentialOwnerGroup");
        List tasks = this.taskService.findGroupTasks(PETER);
        UserTaskTest.assertEquals((int)1, (int)tasks.size());
        tasks = this.taskService.findGroupTasks(MARY);
        UserTaskTest.assertEquals((int)1, (int)tasks.size());
        Task task = (Task)tasks.get(0);
        this.taskService.takeTask(task.getId(), MARY);
        UserTaskTest.assertNull((Object)this.taskService.createTaskQuery().candidate(PETER).uniqueResult());
        this.taskService.completeTask(task.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testHumanPerformerUser() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("userTaskHumanPerformerUser");
        Task task = (Task)this.taskService.findPersonalTasks(MARY).get(0);
        UserTaskTest.assertNotNull((Object)task);
        this.taskService.completeTask(task.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testHumanPerformerVariableExpression() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("user", PETER);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("userTaskHumanPerformerVariable", variables);
        Task task = this.taskService.createTaskQuery().assignee(PETER).uniqueResult();
        UserTaskTest.assertNotNull((Object)task);
        UserTaskTest.assertNull((Object)this.taskService.createTaskQuery().assignee(MARY).uniqueResult());
        this.taskService.completeTask(task.getId());
        this.assertProcessInstanceEnded(processInstance);
    }
}

