/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.task.assignee;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.examples.task.assignee.Order;
import org.jbpm.test.JbpmTestCase;

public class TaskAssigneeTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/task/assignee/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testTaskAssignee() {
        HashMap<String, Order> variables = new HashMap<String, Order>();
        variables.put("order", new Order("johndoe"));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TaskAssignee", variables);
        String pid = processInstance.getId();
        List taskList = this.taskService.findPersonalTasks("johndoe");
        TaskAssigneeTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        TaskAssigneeTest.assertEquals((String)"review", (String)task.getName());
        TaskAssigneeTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        this.taskService.completeTask(task.getId());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskAssigneeTest.assertEquals((int)0, (int)taskList.size());
        processInstance = this.executionService.findProcessInstanceById(pid);
        TaskAssigneeTest.assertTrue((boolean)processInstance.isActive("wait"));
    }
}

