/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.timer.repeat;

import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class TimerRepeatTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/timer/repeat/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testTimerRepeat() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerRepeat");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        TimerRepeatTest.assertNull((Object)this.executionService.getVariable(processInstance.getId(), "escalations"));
        this.managementService.executeJob(job.getId());
        TimerRepeatTest.assertEquals((Object)1, (Object)this.executionService.getVariable(processInstance.getId(), "escalations"));
        job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        TimerRepeatTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TimerRepeatTest.assertEquals((Object)2, (Object)this.executionService.getVariable(processInstance.getId(), "escalations"));
        job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        TimerRepeatTest.assertNotNull((Object)job);
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        String processInstanceId = processInstance.findActiveExecutionIn("guardedWait").getId();
        this.executionService.signalExecutionById(processInstanceId, "go on");
        job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        TimerRepeatTest.assertNull((Object)job);
    }
}

