/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.task.Task;
import org.jbpm.bpmn.parser.BpmnParser;
import org.jbpm.pvm.internal.xml.Problem;
import org.jbpm.test.JbpmTestCase;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusiveGatewayTest
extends JbpmTestCase {
    static BpmnParser bpmnParser = new BpmnParser();

    public List<Problem> parse(String resource) {
        List problems = bpmnParser.createParse().setResource(resource).execute().getProblems();
        return problems;
    }

    public void testNormal() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGateway.bpmn.xml");
        if (!problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)("No problems should have occured. Problems: " + problems));
        }
    }

    public void testNormalXPath() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayXPath.bpmn.xml");
        if (!problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)("No problems should have occured. Problems: " + problems));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalExecuteDecisionCondition() {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/bpmn/exclusiveGateway.bpmn.xml").deploy();
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("test", "value");
            ProcessInstance pi = this.executionService.startProcessInstanceByKey("ExclusiveGateway", variables);
            String pid = pi.getId();
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            List allTasks = taskQuery.list();
            ExclusiveGatewayTest.assertEquals((int)1, (int)allTasks.size());
            ExclusiveGatewayTest.assertEquals((String)"doSomething", (String)((Task)allTasks.get(0)).getActivityName());
            this.taskService.completeTask(((Task)allTasks.get(0)).getId());
            pi = this.executionService.findProcessInstanceById(pid);
            ExclusiveGatewayTest.assertNull((Object)pi);
        }
        finally {
            this.repositoryService.deleteDeploymentCascade(deploymentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoTransitionsEvaluatedToTrueExecuteDecisionCondition() {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/bpmn/exclusiveGatewayTwoTransitions.bpmn.xml").deploy();
        try {
            ProcessInstance pi = this.executionService.startProcessInstanceByKey("exclusiveGatewayTwoTransitions");
            String pid = pi.getId();
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            List allTasks = taskQuery.list();
            ExclusiveGatewayTest.assertEquals((int)1, (int)allTasks.size());
            ExclusiveGatewayTest.assertEquals((String)"testTask1", (String)((Task)allTasks.get(0)).getActivityName());
            this.taskService.completeTask(((Task)allTasks.get(0)).getId());
            allTasks = taskQuery.list();
            ExclusiveGatewayTest.assertEquals((int)1, (int)allTasks.size());
            ExclusiveGatewayTest.assertEquals((String)"testTask2", (String)((Task)allTasks.get(0)).getActivityName());
            HashMap<String, Integer> vars = new HashMap<String, Integer>();
            vars.put("variable", 3);
            this.taskService.completeTask(((Task)allTasks.get(0)).getId(), vars);
            allTasks = taskQuery.list();
            ExclusiveGatewayTest.assertEquals((int)1, (int)allTasks.size());
            this.taskService.completeTask(((Task)allTasks.get(0)).getId());
            pi = this.executionService.findProcessInstanceById(pid);
            ExclusiveGatewayTest.assertNull((Object)pi);
        }
        finally {
            this.repositoryService.deleteDeploymentCascade(deploymentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalExecuteDefault() {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/bpmn/exclusiveGateway.bpmn.xml").deploy();
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("test", "no value");
            ProcessInstance pi = this.executionService.startProcessInstanceByKey("ExclusiveGateway", variables);
            String pid = pi.getId();
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            List allTasks = taskQuery.list();
            ExclusiveGatewayTest.assertEquals((int)1, (int)allTasks.size());
            ExclusiveGatewayTest.assertEquals((String)"doSomethingElse", (String)((Task)allTasks.get(0)).getActivityName());
            this.taskService.completeTask(((Task)allTasks.get(0)).getId());
            pi = this.executionService.findProcessInstanceById(pid);
            ExclusiveGatewayTest.assertNull((Object)pi);
        }
        finally {
            this.repositoryService.deleteDeploymentCascade(deploymentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalExecuteDecisionConditionXPath() {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/bpmn/exclusiveGatewayXPath.bpmn.xml").deploy();
        try {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            Document objectData = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(((Object)((Object)this)).getClass().getResourceAsStream("xmlTestDocument.xml"));
            variables.put("justadocument", objectData);
            variables.put("test", "just");
            ProcessInstance pi = this.executionService.startProcessInstanceByKey("ExclusiveGateway", variables);
            String pid = pi.getId();
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            List allTasks = taskQuery.list();
            ExclusiveGatewayTest.assertEquals((int)1, (int)allTasks.size());
            ExclusiveGatewayTest.assertEquals((String)"doSomething", (String)((Task)allTasks.get(0)).getActivityName());
            this.taskService.completeTask(((Task)allTasks.get(0)).getId());
            pi = this.executionService.findProcessInstanceById(pid);
            ExclusiveGatewayTest.assertNull((Object)pi);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        finally {
            this.repositoryService.deleteDeploymentCascade(deploymentId);
        }
    }

    public void testNonBoundDefault() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayNonBoundDefault.bpmn.xml");
        if (problems == null || problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)"expected problems during parse");
        } else {
            this.assertTextPresent("exclusiveGateway 'Just a gateway' default sequenceFlow 'flow5' does not exist or is not related to this node", problems.get(0).getMsg());
        }
    }

    public void testNonExistingDefault() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayNonExistingDefault.bpmn.xml");
        if (problems == null || problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)"expected problems during parse");
        } else {
            this.assertTextPresent("cvc-id.1: There is no ID/IDREF binding for IDREF 'flow666'", problems.get(0).getMsg());
        }
    }

    public void testMixedValid() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayMixedValid.bpmn.xml");
        if (!problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)("No problems should have occured. Problems: " + problems));
        }
    }

    public void testMixedInvalid() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayMixedInvalid.bpmn.xml");
        if (problems == null || problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)"expected problems during parse");
        } else {
            this.assertTextPresent("exclusiveGateway 'Just a gateway' has the wrong number of incomming (1) and outgoing (2) transitions for gatewayDirection='mixed'", problems.get(0).getMsg());
        }
    }

    public void testConvergingInvalid() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayConvergingInvalid.bpmn.xml");
        if (problems == null || problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)"expected problems during parse");
        } else {
            this.assertTextPresent("Gateway 'Just a gateway' has the wrong number of incomming (1) and outgoing (2) transitions for gatewayDirection='converging'", problems.get(0).getMsg());
        }
    }

    public void testDivergingInvalid() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayDivergingInvalid.bpmn.xml");
        if (problems == null || problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)"expected problems during parse");
        } else {
            this.assertTextPresent("exclusiveGateway 'Just a gateway' has the wrong number of incomming (2) and outgoing (2) transitions for gatewayDirection='diverging'", problems.get(0).getMsg());
        }
    }

    public void testInvalidConditionExpression() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/exclusiveGatewayInvalidConditionExpression.bpmn.xml");
        if (problems == null || problems.isEmpty()) {
            ExclusiveGatewayTest.fail((String)"expected problems during parse");
        } else {
            this.assertTextPresent("Type of the conditionExpression on sequenceFlow with id=flow2 is of onsupported type 'bpmn:tExpression", problems.get(0).getMsg());
        }
    }
}

