/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class GroupBasicsTest
extends JbpmTestCase {
    public void testSimplestGroup() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='group' />  </start>  <group name='group'>    <start>      <transition to='a' />    </start>    <state name='a'>      <transition to='done' />    </state>    <end name='done' />    <transition to='end' />  </group>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testGroupWithoutStartActivity() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='group' />  </start>  <group name='group'>    <state name='a'>      <transition to='done' />    </state>    <end name='done' />    <transition to='end' />  </group>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testGroupMultipleEntryStartActivities() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='choose' />  </start>  <decision name='choose' expr='#{theWayToGo}'>    <transition name='left' to='left' />    <transition name='right' to='right' />  </decision>  <group name='group'>    <start name='left'>      <transition to='a' />    </start>    <start name='right'>      <transition to='b' />    </start>    <state name='a'>      <transition to='done' />    </state>    <state name='b'>      <transition to='done' />    </state>    <end name='done' />    <transition to='end' />  </group>  <end name='end' /></process>");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("theWayToGo", "left");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group", variables);
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
        variables.put("theWayToGo", "right");
        processInstance = this.executionService.startProcessInstanceByKey("Group", variables);
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("b"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testGroupDirectEntryTransition() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='direct' />  </start>  <group name='group'>    <start name='direct'>      <transition to='a' />    </start>    <state name='a'>      <transition to='done' />    </state>    <end name='done' />    <transition to='end' />  </group>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testGroupWithoutEndActivity() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='group' />  </start>  <group name='group'>    <start>      <transition to='a' />    </start>    <state name='a' />    <transition to='end' />  </group>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testGroupMultipleExitEndActivities() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='group' />  </start>  <group name='group'>    <start>      <transition to='a' />    </start>    <state name='a'>      <transition name='a' to='exitA' />      <transition name='b' to='exitB' />    </state>    <end name='exitA'>      <transition to='endA' />    </end>    <end name='exitB'>      <transition to='endB' />    </end>  </group>  <end name='endA' />  <end name='endB' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId(), "a");
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
        processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId(), "b");
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testGroupDirectExitTransition() {
        this.deployJpdlXmlString("<process name='Group'>  <start>    <transition to='group' />  </start>  <group name='group'>    <start>      <transition to='a' />    </start>    <state name='a'>      <transition to='end' />    </state>  </group>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Group");
        GroupBasicsTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        GroupBasicsTest.assertTrue((boolean)processInstance.isEnded());
    }
}

