/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.subprocess;

import org.jbpm.test.JbpmTestCase;

public class SubProcessDeleteTest
extends JbpmTestCase {
    public void testSubProcessDelete() {
        this.deployJpdlXmlString("<process name='MainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-key='SubProcessReview'>    <transition to='next step'/>  </sub-process>  <state name='next step'/></process>");
        this.deployJpdlXmlString("<process name='SubProcessReview'>  <start>    <transition to='get approval'/>  </start>  <task name='get approval' assignee='johndoe'>    <transition to='ok'/>  </task>  <end name='ok' /></process>");
        String pid = this.executionService.startProcessInstanceByKey("MainProcess").getId();
        SubProcessDeleteTest.assertEquals((int)2, (int)this.executionService.createProcessInstanceQuery().list().size());
        this.executionService.deleteProcessInstance(pid);
        SubProcessDeleteTest.assertEquals((int)0, (int)this.executionService.createProcessInstanceQuery().list().size());
        SubProcessDeleteTest.assertEquals((int)0, (int)this.taskService.createTaskQuery().list().size());
    }

    public void testMultipleSubProcess() {
        this.deployJpdlXmlString("<process name='MainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-key='SubProcessReview'>    <transition to='second sub process'/>  </sub-process>  <sub-process name='second sub process' sub-process-key='SubProcessReview'>    <transition to='next step'/>  </sub-process>  <state name='next step'/></process>");
        this.deployJpdlXmlString("<process name='SubProcessReview'>  <start>    <transition to='ok'/>  </start>  <end name='ok' /></process>");
        String pid = this.executionService.startProcessInstanceByKey("MainProcess").getId();
        SubProcessDeleteTest.assertEquals((int)1, (int)this.executionService.createProcessInstanceQuery().list().size());
        this.executionService.deleteProcessInstance(pid);
        SubProcessDeleteTest.assertEquals((int)0, (int)this.executionService.createProcessInstanceQuery().list().size());
    }

    public void testSubProcessWithFork() {
        this.deployJpdlXmlString("<process name='MainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-key='SubProcessReview'>    <transition to='next step'/>  </sub-process>  <state name='next step'/></process>");
        this.deployJpdlXmlString("<process name='SubProcessReview'>  <start>    <transition to='fork'/>  </start>  <fork name='fork'>    <transition to='ok'/>    <transition to='wait'/>  </fork>  <state name='wait'/>  <end name='ok' /></process>");
        String pid = this.executionService.startProcessInstanceByKey("MainProcess").getId();
        SubProcessDeleteTest.assertEquals((int)1, (int)this.executionService.createProcessInstanceQuery().list().size());
        this.executionService.deleteProcessInstance(pid);
        SubProcessDeleteTest.assertEquals((int)0, (int)this.executionService.createProcessInstanceQuery().list().size());
    }
}

