/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.task;

import java.util.Date;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskSwimlaneTest
extends JbpmTestCase {
    public void testSwimlaneTaskEnd() {
        this.deployJpdlXmlString("<process name='TaskSwimlane'>   <swimlane name='sales representative' assignee='johndoe' />  <start>    <transition to='enter order data' />  </start>  <task name='enter order data'        swimlane='sales representative'>    <transition to='end'/>  </task>  <end name='end' /></process>");
        this.executionService.startProcessInstanceByKey("TaskSwimlane");
        List tasks = this.taskService.findPersonalTasks("johndoe");
        TaskSwimlaneTest.assertEquals((int)1, (int)tasks.size());
        Task task = (Task)tasks.get(0);
        this.taskService.completeTask(task.getId());
        TaskSwimlaneTest.assertEquals((long)0L, (long)this.executionService.createProcessInstanceQuery().count());
        TaskSwimlaneTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    public void testConcurrentSwimlaneTaskEnd() {
        this.deployJpdlXmlString("<process name='TaskConcurrentSwimlane'>   <swimlane name='sales representative' assignee='johndoe' />  <start>    <transition to='fork' />  </start>  <fork name='fork'>    <transition to='enter order data' />    <transition to='sign contract' />  </fork>  <task name='enter order data'        swimlane='sales representative'>    <transition to='join'/>  </task>  <task name='sign contract'        swimlane='sales representative'>    <transition to='join'/>  </task>  <join name='join'>    <transition to='end' />  </join>  <end name='end' /></process>");
        this.executionService.startProcessInstanceByKey("TaskConcurrentSwimlane");
        List tasks = this.taskService.findPersonalTasks("johndoe");
        TaskSwimlaneTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.completeTask(((Task)tasks.get(0)).getId());
        this.taskService.completeTask(((Task)tasks.get(1)).getId());
        TaskSwimlaneTest.assertEquals((long)0L, (long)this.executionService.createProcessInstanceQuery().count());
        TaskSwimlaneTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    public void testSwimlaneWithMultiplicity() {
        this.deployJpdlXmlString("<process key='join-multiplicity-test' name='join-multiplicity-test' xmlns='http://jbpm.org/4.3/jpdl'>   <swimlane name='swimlane1' assignee='user1'/>   <swimlane name='swimlane2' assignee='user2'/>   <start g='165,4,48,48' name='start1'>      <transition g='-50,-20' name='to task1' to='task1'/>   </start>   <end g='165,511,48,48' name='end1'/>   <task g='143,97,92,52' name='task1' swimlane='swimlane1'>      <transition g='-50,-20' name='to fork1' to='fork1'/>   </task>   <task g='9,282,92,52' name='task2' swimlane='swimlane1'>      <transition g='-49,-20' name='to join1' to='join1'/>   </task>   <task g='283,282,92,52' name='task3' swimlane='swimlane2'>      <transition g='-49,-20' name='to join1' to='join1'/>   </task>   <fork g='165,185,48,48' name='fork1'>      <transition g='-50,-20' name='to task2' to='task2'/>      <transition g='-50,-20' name='to task3' to='task3'/>   </fork>   <join continue='async' g='165,387,48,48' multiplicity='1' name='join1'>      <transition g='-50,-20' name='to end1' to='end1'/>   </join></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("join-multiplicity-test");
        String processInstanceId = processInstance.getId();
        List user1Tasks = this.taskService.findPersonalTasks("user1");
        TaskSwimlaneTest.assertEquals((int)1, (int)user1Tasks.size());
        Task task1 = (Task)user1Tasks.get(0);
        this.taskService.completeTask(task1.getId(), "to fork1");
        user1Tasks = this.taskService.findPersonalTasks("user1");
        TaskSwimlaneTest.assertEquals((int)1, (int)user1Tasks.size());
        Task task2 = (Task)user1Tasks.get(0);
        this.taskService.completeTask(task2.getId(), "to join1");
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        TaskSwimlaneTest.assertEquals((int)1, (int)jobs.size());
        Job join1Job = (Job)jobs.get(0);
        this.managementService.executeJob(join1Job.getId());
        Date endTime = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult().getEndTime();
        TaskSwimlaneTest.assertNotNull((Object)endTime);
    }

    public void testTaskParse() {
        this.deployJpdlXmlString("<process name='Swimlane' xmlns='http://jbpm.org/4.3/jpdl'><swimlane name='user'/><start g='168,19,48,48' name='start1'>  <transition g='-61,-18' name='to FirstTask' to='FirstTask'/></start><task g='155,86,92,52' name='FirstTask' swimlane='user'>  <transition g='-64,-18' name='to timerTask' to='timerTask'/></task><task g='157,228,92,52' name='timerTask' swimlane='user'>  <transition g='-42,-18' name='to end1' to='end1'>    <timer duedate='30 seconds' />  </transition></task><end g='176,330,48,48' name='end1'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Swimlane");
        Task firstTask = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.taskService.assignTask(firstTask.getId(), "alex");
        firstTask = this.taskService.getTask(firstTask.getId());
        TaskSwimlaneTest.assertEquals((String)"alex", (String)firstTask.getAssignee());
        TaskSwimlaneTest.assertEquals((String)"FirstTask", (String)firstTask.getName());
        this.taskService.completeTask(firstTask.getId());
        Task timerTask = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).uniqueResult();
        TaskSwimlaneTest.assertEquals((String)"timerTask", (String)timerTask.getName());
        TaskSwimlaneTest.assertEquals((String)"alex", (String)timerTask.getAssignee());
    }
}

