/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.history;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class EndProcessInstanceTest
extends JbpmTestCase {
    public void testCancelProcessInstance() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='wait' />  </start>  <state name='wait'>    <transition to='end' />  </state>  <end name='end' /></process>");
        ProcessInstance execution = this.executionService.startProcessInstanceByKey("ICL");
        String processInstanceId = execution.getId();
        this.executionService.endProcessInstance(processInstanceId, "cancel");
        List processInstances = this.executionService.createProcessInstanceQuery().processInstanceId(processInstanceId).list();
        EndProcessInstanceTest.assertEquals((int)0, (int)processInstances.size());
        HistoryProcessInstance historyProcessInstance = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstanceId).uniqueResult();
        EndProcessInstanceTest.assertNotNull((Object)historyProcessInstance.getStartTime());
        EndProcessInstanceTest.assertNotNull((Object)historyProcessInstance.getEndTime());
        EndProcessInstanceTest.assertEquals((String)"cancel", (String)historyProcessInstance.getState());
    }

    public void testProcessInstanceEndState() {
        this.deployJpdlXmlString("<process name='test1'>  <start g='4,289,48,48' name='start1'>    <transition name='to task1' to='task1' g='-44,-18'/>  </start>  <task name='task1' g='152,277,92,52'>    <transition name='Reject (risk)' to='Rejected by risk' g='-42,-18'/>    <transition name='Reject (reporting)' to='Rejected by reporting' g='-42,-18'/>  </task>  <end name='Rejected by risk' g='328,232,48,48'/>  <end name='Rejected by reporting' g='335,347,48,48'/></process>");
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("test1");
        Task task = this.taskService.createTaskQuery().processInstanceId(pi.getId()).uniqueResult();
        this.taskService.completeTask(task.getId(), "Reject (risk)");
        this.assertProcessInstanceEnded(pi);
        HistoryProcessInstance historyPi = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(pi.getId()).uniqueResult();
        EndProcessInstanceTest.assertEquals((String)"ended", (String)historyPi.getState());
    }
}

