/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.util.List;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.test.JbpmTestCase;

public class ProcessDefinitionQueryTest
extends JbpmTestCase {
    public void testQueryProcessDefinitionsEmpty() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        ProcessDefinitionQueryTest.assertEquals((int)0, (int)processDefinitions.size());
    }

    public void testQueryProcessDefinitionsNameLike() {
        this.deployJpdlXmlString("<process name='make print'>  <start /></process>");
        this.deployJpdlXmlString("<process name='use phone'>  <start /></process>");
        this.deployJpdlXmlString("<process name='make friends'>  <start /></process>");
        this.deployJpdlXmlString("<process name='clean whiteboard'>  <start /></process>");
        this.deployJpdlXmlString("<process name='fix coffeemaker'>  <start /></process>");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%make%").orderAsc("idProperty.objectName").list();
        ProcessDefinitionQueryTest.assertEquals((String)"fix coffeemaker", (String)((ProcessDefinition)processDefinitions.get(0)).getName());
        ProcessDefinitionQueryTest.assertEquals((String)"make friends", (String)((ProcessDefinition)processDefinitions.get(1)).getName());
        ProcessDefinitionQueryTest.assertEquals((String)"make print", (String)((ProcessDefinition)processDefinitions.get(2)).getName());
    }

    public void testQueryProcessDefinitionsKeyLike() {
        this.deployJpdlXmlString("<process name='make print'>  <start /></process>");
        this.deployJpdlXmlString("<process name='use phone'>  <start /></process>");
        this.deployJpdlXmlString("<process name='make friends'>  <start /></process>");
        this.deployJpdlXmlString("<process name='make friends'>  <start /></process>");
        this.deployJpdlXmlString("<process name='make friends'>  <start /></process>");
        this.deployJpdlXmlString("<process name='clean whiteboard'>  <start /></process>");
        this.deployJpdlXmlString("<process name='fix coffeemaker'>  <start /></process>");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("make%").orderAsc("idProperty.stringValue").list();
        ProcessDefinitionQueryTest.assertEquals((String)"make_friends-1", (String)((ProcessDefinition)processDefinitions.get(0)).getId());
        ProcessDefinitionQueryTest.assertEquals((String)"make_friends-2", (String)((ProcessDefinition)processDefinitions.get(1)).getId());
        ProcessDefinitionQueryTest.assertEquals((String)"make_friends-3", (String)((ProcessDefinition)processDefinitions.get(2)).getId());
        ProcessDefinitionQueryTest.assertEquals((String)"make_print-1", (String)((ProcessDefinition)processDefinitions.get(3)).getId());
    }
}

