/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.List;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskQueryCandidatesTest
extends JbpmTestCase {
    String salesGroupId;
    String developmentGroupId;

    public void setUp() throws Exception {
        super.setUp();
        this.identityService.createUser("johndoe", "John", "Doe");
        this.identityService.createUser("joesmoe", "Joe", "Smoe");
        this.identityService.createUser("jackblack", "Jack", "Black");
        this.salesGroupId = this.identityService.createGroup("sales");
        this.identityService.createMembership("johndoe", this.salesGroupId);
        this.identityService.createMembership("joesmoe", this.salesGroupId);
        this.developmentGroupId = this.identityService.createGroup("development");
        this.identityService.createMembership("jackblack", this.developmentGroupId);
        this.identityService.createMembership("johndoe", this.developmentGroupId);
    }

    public void tearDown() throws Exception {
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("jackblack");
        this.identityService.deleteGroup(this.salesGroupId);
        this.identityService.deleteGroup(this.developmentGroupId);
        super.tearDown();
    }

    public void testDirectUserCandidate() {
        Task task = this.taskService.newTask();
        task.setName("do laundry");
        String taskId = this.taskService.saveTask(task);
        this.taskService.addTaskParticipatingUser(taskId, "johndoe", "candidate");
        task = this.taskService.newTask();
        task.setName("dishes");
        task.setAssignee("johndoe");
        String johnsOtherTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("dishes");
        String joesOtherTaskId = this.taskService.saveTask(task);
        List groupTasks = this.taskService.findGroupTasks("johndoe");
        TaskQueryCandidatesTest.assertEquals((int)1, (int)groupTasks.size());
        TaskQueryCandidatesTest.assertEquals((String)taskId, (String)((Task)groupTasks.get(0)).getId());
        groupTasks = this.taskService.findGroupTasks("joesmoe");
        TaskQueryCandidatesTest.assertEquals((int)0, (int)groupTasks.size());
        groupTasks = this.taskService.findGroupTasks("jackblack");
        TaskQueryCandidatesTest.assertEquals((int)0, (int)groupTasks.size());
        this.taskService.deleteTaskCascade(taskId);
        this.taskService.deleteTaskCascade(johnsOtherTaskId);
        this.taskService.deleteTaskCascade(joesOtherTaskId);
    }

    public void testGroupCandidate() {
        Task task = this.taskService.newTask();
        task.setName("do laundry");
        String taskId = this.taskService.saveTask(task);
        this.taskService.addTaskParticipatingGroup(taskId, this.salesGroupId, "candidate");
        task = this.taskService.newTask();
        task.setName("dishes");
        task.setAssignee("johndoe");
        String johnsOtherTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("dishes");
        String joesOtherTaskId = this.taskService.saveTask(task);
        List groupTasks = this.taskService.findGroupTasks("johndoe");
        TaskQueryCandidatesTest.assertEquals((int)1, (int)groupTasks.size());
        TaskQueryCandidatesTest.assertEquals((String)taskId, (String)((Task)groupTasks.get(0)).getId());
        groupTasks = this.taskService.findGroupTasks("joesmoe");
        TaskQueryCandidatesTest.assertEquals((int)1, (int)groupTasks.size());
        TaskQueryCandidatesTest.assertEquals((String)taskId, (String)((Task)groupTasks.get(0)).getId());
        groupTasks = this.taskService.findGroupTasks("jackblack");
        TaskQueryCandidatesTest.assertEquals((int)0, (int)groupTasks.size());
        this.taskService.deleteTaskCascade(taskId);
        this.taskService.deleteTaskCascade(johnsOtherTaskId);
        this.taskService.deleteTaskCascade(joesOtherTaskId);
    }

    public void testGroupCandidateDuplicate() {
        Task task = this.taskService.newTask();
        task.setName("do laundry");
        String taskId = this.taskService.saveTask(task);
        this.taskService.addTaskParticipatingGroup(taskId, this.salesGroupId, "candidate");
        this.taskService.addTaskParticipatingGroup(taskId, this.developmentGroupId, "candidate");
        List groupTasks = this.taskService.findGroupTasks("johndoe");
        TaskQueryCandidatesTest.assertEquals((int)1, (int)groupTasks.size());
        TaskQueryCandidatesTest.assertEquals((String)taskId, (String)((Task)groupTasks.get(0)).getId());
        groupTasks = this.taskService.findGroupTasks("joesmoe");
        TaskQueryCandidatesTest.assertEquals((int)1, (int)groupTasks.size());
        TaskQueryCandidatesTest.assertEquals((String)taskId, (String)((Task)groupTasks.get(0)).getId());
        groupTasks = this.taskService.findGroupTasks("jackblack");
        TaskQueryCandidatesTest.assertEquals((int)1, (int)groupTasks.size());
        this.taskService.deleteTaskCascade(taskId);
    }

    public void testCountGroupCandidateDuplicate() {
        Task task = this.taskService.newTask();
        task.setName("do laundry");
        String taskId = this.taskService.saveTask(task);
        this.taskService.addTaskParticipatingGroup(taskId, this.salesGroupId, "candidate");
        this.taskService.addTaskParticipatingGroup(taskId, this.developmentGroupId, "candidate");
        long count = this.taskService.createTaskQuery().candidate("johndoe").count();
        TaskQueryCandidatesTest.assertEquals((long)1L, (long)count);
        this.taskService.deleteTaskCascade(taskId);
    }

    public void testCountUserCandidateDuplicate() {
        Task task = this.taskService.newTask();
        task.setName("do laundry");
        String taskId = this.taskService.saveTask(task);
        this.taskService.addTaskParticipatingUser(taskId, "boss_rigging", "candidate");
        this.taskService.addTaskParticipatingUser(taskId, "boss_rigging", "candidate");
        TaskQueryCandidatesTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().candidate("boss_rigging").count());
        this.taskService.deleteTaskCascade(taskId);
    }
}

